package sim.app.crowd3d;

import sim.display.*;
import sim.display3d.*;
import sim.portrayal3d.*;
import sim.portrayal3d.simple.*;
import sim.portrayal3d.continuous.*;

import javax.swing.*;

public class Crowd3DWithUI extends GUIState
    {
                
    public JFrame mDisplayFrame; 
    FieldPortrayal3D boidsP;
    Portrayal3D wireFrameP;

    public static void main(String[] args)
        {
        Crowd3DWithUI boids = new Crowd3DWithUI(new CrowdSim(System.currentTimeMillis()));

        Console c = new Console(boids);
        c.setVisible(true);        
        }

    public Crowd3DWithUI()
        {
        this(new CrowdSim(System.currentTimeMillis())); 
        }
    public Crowd3DWithUI(CrowdSim b)
        {
        super(b);
        boidsP = new ContinuousPortrayal3D();
        wireFrameP = new WireFrameBoxPortrayal3D(0,0,0, b.spaceWidth, b.spaceHeight, b.spaceDepth);
        }
    
    public String getName() { return "Spacing Demo"; }
        
    public void start()
        {
        super.start();
        boidsP.setField(((CrowdSim)state).boidSpace);
        
        mDisplay.reset();

        // rebuild the scene graph
        mDisplay.createSceneGraph();        
        }
    
    public Display3D mDisplay;

    public void init(Controller c)
        {
        CrowdSim cState = (CrowdSim)state;
        super.init(c);
        mDisplay = new Display3D(500,500,this,1);

        mDisplay.attach(wireFrameP, "Fish tank");
        boidsP.setPortrayalForAll(new GullPortrayal3D());
        mDisplay.attach(boidsP, "boids");
                
        mDisplay.translate(-.5*cState.spaceWidth,-.5*cState.spaceHeight,-0.5*cState.spaceDepth);
        mDisplay.scale(1.0/Math.max(cState.spaceWidth, Math.max(cState.spaceHeight, cState.spaceDepth)));

        mDisplayFrame = mDisplay.createFrame();
        c.registerFrame(mDisplayFrame);   // register the frame so it appears in the "Display" list
        mDisplayFrame.setVisible(true);
        }
        
    public void quit()
        {
        super.quit();

        if (mDisplayFrame!=null) mDisplayFrame.dispose();
        mDisplayFrame = null;  
        mDisplay = null;       
        }


    }
