%{
double vbltable[26];
%}

%union {
   VYint val;
   int dval;
   int vblno;
}

%token <dval> NUMBER 
%token <vblno> NAME 
%type <val> expression
%left '-' '+'
%left '*' '/'
%nonassoc UMINUS

%%
statement_list:	statement '\n'
	|	statement_list statement '\n'
	;

statement:	NAME '=' expression	{ vbltable[$1] = $3; }
	|	expression		{ printf("= %d\n", $1); }
	;

expression:	expression '+' expression { $$ = $1 + $3; }
	|	expression '-' expression { $$ = $1 - $3; }
	|	expression '*' expression { $$ = $1 * $3; }
	|	expression '/' expression
				{	if($3 == 0.0)
						yyerror("divide by zero");
					else
						$$ = $1 / $3; 
				}
	|	'(' expression ')'	{ $$ = $2; }
	|	NUMBER			{$$ = $1; }
	|	NAME		{$$ = vbltable[$1]; }
	;
%%
