%{
#include <math.h>
/*  Lexical specification for Pascal subset */
/*  Currently the only tokens returning additional information */
/*  are NUM (ival), REAL_NUM (rval), ID (str_type), and REL_OP (str_type)*/
#include "y.tab.h"
%}
%%
and                     {return(AND_T);}
array                   {return(ARRAY_T);}
begin                   {return(BEGIN_T);}
do                      {return(DO_T);}
else                    {return(ELSE_T);}
end                     {return(END_T);}
function                {return(FUNCTION_T);}
if                      {return(IF_T);}
integer                 {return(INTEGER_T);}
mod                     {return(MOD_T);}
not                     {return(NOT_T);}
of                      {return(OF_T);}
or                      {return(OR_T);}
procedure               {return(PROCEDURE_T);}
program                 {return(PROGRAM_T);}
read                    {return(READ_T);}
real                    {return(REAL_T);}
then                    {return(THEN_T);}
var                     {return(VAR_T);}
while                   {return(WHILE_T);}
write                   {return(WRITE_T);}
\[                      {return('[');}
\]                      {return(']');}
\(                      {return('(');}
\)                      {return(')');}
\;                      {return(';');}
\:                      {return(':');}
\.                      {return('.');}
\,                      {return(',');}
\+                      {return('+');}
\-                      {return('-');}
\*                      {return('*');}
\/                      {return('/');}
".."                    {return(DOTDOT);}
":="                    {return(ASSIGN_OP);}
"=" |                   
"<>" |
">=" |
"<=" |
">" |
"<"                     {return(REL_OP);}
t[0-9]+                 { return(ID);}
[a-zA-Z][a-zA-Z0-9]*    { return(ID);}
[+-]?[0-9]+             { return(NUM);}
[+-]?[0-9]+"."[0-9]+    {return(REAL_NUM);}
\{[^}{]*\}              { }
[ \t\n]                 { }
%%
