/***********************************************************************
 
 What This Is:      Interface to the Graphic Parse Modual
 Author:            Laura Deddens
 Email:             lelo@cats.ucsc.edu
 Last Modified:     5 September 1996

 This modual handles all the details of bringing up a motif widow that
    allows the user to step through a parseing and see a visualization
    of the corresponding stack and parse tree.

Note:   You must include parseTree.h and parseTreeList.h  before
   including this file.
 
***********************************************************************/


/***********************************************************************
 This global variable should be set to the number of int values that
 will be associated with each node in the parse.  It should get
 initialized to this value once before MyMain() is called and then
 never changed.
***********************************************************************/
extern int gNumValues;


/***********************************************************************
 This procedure sets up the Motif window and widgets such as the push
 buttons, scroll bars, and drawing areas.  It then enters an event loop.
 From within this event loop the user may, by clicking on push buttons,
 caused yyparse() to get called.  Before this procedure is called,
 gNumValues should be initialized.  This procedure should be called by
 main() declared in the yacc specification.
***********************************************************************/
void MyMain(int argc, char *argv[]);

/***********************************************************************
 Each time yacc reduces a rule that has a right-hand-side, this
    procedure should be called to begin building the parse tree
    that corespondes to the left-hand-side.
 Preconditions:   tree is NULL
                  nodeName is the name of this node
                  nameLength is the length of nodeName
 Postconditions:  tree will be initialized to be a parse tree with no
    children.  It will have gNumValues values associated with it, each
    initialized to 0.  Its string will be nodeName and its (x,y)
    position will be (0,0).
 Note:            A later call to HandleReduciton should be made to
    assign it its children and calculate its (x,y) position.
***********************************************************************/
void CreateNonLeafParseTree(ParseTreeHdl * tree, char *nodeName, int nameLength);

/***********************************************************************
 Each time yacc puts a new element on its stack with out first poping
    off other elements (i.e., when it puts on the stack either a token
    or a left-hand-side that has no right-hand-side) this procedure
    should get called instead of CreateParseTree().
 Preconditions:   tree is NULL
                  leafName is the name of this node
                  nameLength is the length of leafName
 Postconditions:  tree will be initialized to be a parse tree with no
    children.  It will have gNumValues values associated with it each
    initialized to 0.  Its string will be leafName and its (x,y)
    position will be such that it is just to the right of the last
    leaf created with this function.  If this is the first such leaf
    then it will be positioned in the lower left corner of the drawing
    area.
***********************************************************************/
void CreateLeafParseTree(ParseTreeHdl *tree, char *leafName, int nameLength);

/***********************************************************************
 Each time yacc does a reduction this procedure should get called.  Thus
    the action associated with a rule should first contain the original
    code of the action and then, for example if gNumValues is 2, there
    are 3 elements on the right-hand-side, and lhs is the name of
    the left-hand-side of the rule, then the following code should be
    added last to the action:
        {
        ParseTreeListHdl list = NULL;
        $$.tree = NULL;
        CreateNonLeafParseTree((ParseTreeHdl *)&($$.tree), "lhs",
                               strlen("lhs"));
        SetParseTreeOrgValue($$.tree, $$.x[0], 0);
        SetParseTreeOrgValue($$.tree, $$.x[1], 1);
        CreateParseTreeList(&list);
        AddFirst(list, $$.tree);
        AddLast(list, $1.tree);
        AddLast(list, $2.tree);
        AddLast(list, $3.tree);
        HandleReduction(&list);
        }
    If a rule had 0 elements on the right-hand-side then the code would
    be like this instead:
        {
        ParseTreeListHdl list = NULL;
        $$.tree = NULL;
        CreateLeafParseTree((ParseTreeHdl *)&($$.tree), "lhs", strlen("lhs"));
        SetParseTreeOrgValue($$.tree, $$.x[0], 0);
        SetParseTreeOrgValue($$.tree, $$.x[1], 1);
        CreateParseTreeList(&list);
        AddFirst(list, $$.tree);
        HandleReduction(&list);
        }
 Precoditions:   list has been initialized by CreateParseTreeList
                 list's first element is $$.tree which has been
    initialized by either CreateNonLeafParseTree or CreateLeafParseTree
                 the list's second thru last elements are $1.tree thru
    $n.tree where n is the number of right-hand-side elements.
 Postconditions:  graphicParse's representation of the state of the
    parser will be updated and the drawings of the stack and tree
    will be updated on the screen.  $$.tree's (x,y) position will
    have been calculated and it will have been assigned its children.
***********************************************************************/
void HandleReduction(ParseTreeListHdl *list);

/***********************************************************************
 Each time yacc gets a token and puts it on the stack this procedure
    should get called.
 Precondition:   tokenTree has been initialized with CreateLeafParseTree
    and SetParseTreOrgValue has been used gNumValues times on tokenTree
    to set each of its associated values
 Postcondition:  graphicParse's representation of the state of the
    parser will be updated and the drawings of the stack and tree
    will be updated on the screen.
***********************************************************************/
void HandleToken(ParseTreeHdl tokenTree);
