/***********************************************************************
 
 What This Is:      Interface needed for use with stepPar
 Author:            Laura Deddens
 Email:             lelo@cats.ucsc.edu
 Last Modified:     5 September 1996
 
***********************************************************************/


/***********************************************************************
 Values that may be taken on by gStepParse_flag
***********************************************************************/
#define NORMAL		1
#define REDUCTIONS      2


/***********************************************************************
 global variable which must be initialized to either NORMAL or
 REDUCTIONS before yyparse() is called
***********************************************************************/
extern int gStepParse_flag;


/***********************************************************************
 This is a specialized yyparse().
 Precondition:   gStepParse_flag must be initialized to either NORMAL or
    REDUCTIONS
 Postcondition:  If gStepParse_flag is NORMAL then this function behaves
    just like the standard yyparse, otherwise if gStepParse_flag is
    REDUCTIONS then this function will only parse as far as either
    getting one token or performing one reduction.
                 returns 0 if completed parse, 1 if syntax error was
    found and not recovered from, and 2 if paused in middle of parse
***********************************************************************/
extern int yyparse(void);
