
# line 2 "./ny.temp.y"

typedef enum {ny_empty,ny_terminal,ny_nonTerminal} ny_TokenType;


#include <stdio.h>
#include "nytags.h"

char *union_found();
char *output_default_types();
char *special();
char *output_spec();
char *attr_type;
char *dump_attrs(), *new_info();
char *check_name();
char *new_lhs();
char *visual(), *extended(), *init_count(), *re_init_count(), *process();

/* tag meanings:
  FIND_UNION -- detects whether there is a user-defined union present
                sets a flag approprately
  DEFAULT -- transforms a yacc specification that has no union.
     Here we have 2 cases; either there is no attribute use, or 
     there is a default integer attribute.  In this case, we define
     a union with a single integer attribute.  All tokens and types
     get this default type.

  EXTEND -- this deals with the more interesting case where there is
     a union defined and this union needs to be extended appropriately

E. White
*/

# define UNION_T 257
# define TOKEN_T 258
# define LEFT_T 259
# define RIGHT_T 260
# define TYPE_T 261
# define NONASSOC_T 262
# define PREC_T 263
# define NAME 264
# define DIVIDER 265
# define CHAR 266
# define STRING 267
# define START_C 268
# define STOP_C 269
# define LHS 270
# define RHS 271
# define BRACKET_KEYWORD 272
# define POUND_KEYWORD 273
# define KEYWORD 274
# define SPECIAL_KEYWORD 275

#ifdef __STDC__
#include <stdlib.h>
#include <string.h>
#else
#include <malloc.h>
#include <memory.h>
#endif

#include <values.h>

#ifdef __cplusplus

#ifndef yyerror
	void yyerror(const char *);
#endif

#ifndef yylex
#ifdef __EXTERN_C__
	extern "C" { int yylex(void); }
#else
	int yylex(void);
#endif
#endif
	int yyparse(void);

#endif
#define yyclearin yychar = -1
#define yyerrok yyerrflag = 0
extern int yychar;
extern int yylineno; extern int yyerrflag;
#ifndef YYSTYPE
#define YYSTYPE int
#endif
YYSTYPE yylval;
YYSTYPE yyval;
typedef int yytabelem;
#ifndef YYMAXDEPTH
#define YYMAXDEPTH 150
#endif
#if YYMAXDEPTH > 0
int yy_yys[YYMAXDEPTH], *yys = yy_yys;
YYSTYPE yy_yyv[YYMAXDEPTH], *yyv = yy_yyv;
#else	/* user does initial allocation */
int *yys;
YYSTYPE *yyv;
#endif
static int yymaxdepth = YYMAXDEPTH;
# define YYERRCODE 256

# line 240 "./ny.temp.y"


char *myprint(s)
char *s;
{
  if(s != 0) fputs(s,stdout);
  return NULL;
}

yyerror()
{
  fprintf(stderr, "syntax error on line %d\n",yylineno);
  fflush(stderr);
  exit(1);
}

typedef struct {
  char *name;
  char *attr_name;
  int special;
} attr_info;
attr_info attributes[256];
int num_attrs = 0;

char *special_names[100];
int rule_elem[100];
int specialct = 0;
int count;
char *init_count() {count = 0; return NULL;}
char *re_init_count() {count = 1; return NULL;}
char *process(int argc,char**argv) {
  int ct;
  rule_elem[count] = -1;  
  for (ct=0;ct<num_attrs;ct++) 
    if (strcmp(argv[0],attributes[ct].name) == 0)
       rule_elem[count] = ct;  
  count++;
  return NULL;
}

char *visual() {
  if (rule_elem[0] != -1) 
    if (attributes[rule_elem[0]].special >= 0) {
      printf("$$.x[%d] =  $$.%s;\n",attributes[rule_elem[0]].special,
         attributes[rule_elem[0]].attr_name); 
    }
  return NULL;
}
char *extended(int argc, char**argv) {
  if (strcmp(argv[0],"$$") ==0) {
    printf(".%s",attributes[rule_elem[0]].attr_name);
  } else {
   (argv[0])++;
    printf(".%s",attributes[rule_elem[atoi(argv[0])]].attr_name);
   
  }
  return NULL;
}

char *special(int argc, char**argv) {
  int i;
  special_names[specialct] = (char*)malloc(strlen(argv[0])+1);
  strcpy(special_names[specialct], argv[0]); 
  for (i = 0;i<num_attrs;i++) {
     if (strcmp(attributes[i].attr_name,argv[0]) == 0)
       attributes[i].special = specialct;
  }
  specialct++; return NULL;}

char *output_spec(){if (specialct) printf("int x[%d];\n",specialct); 
  else printf("int x[1];\n"); return NULL;}

int union_f ;

char*union_found() {union_f = 1; return NULL;}

char *output_default_types() {
  printf("%%union {\n  struct {\n     int x[1];  \n} vyacc_attrs;\n}\n");
  return NULL;}

char* dump_attrs() {
  int ct;
  printf("/*\n");
  for (ct=0;ct<num_attrs;ct++) {
    printf("%d: %s has type %s (%d)\n",ct,attributes[ct].name,attributes[ct].attr_name,
        attributes[ct].special);
  }
  printf("*/\n");
  return NULL;
}

char *check_name(int argc,char**argv) {
  int i;
  if (argc == 1) {
    for (i=0;i<num_attrs;i++)
      if (strcmp(argv[0],attributes[i].name) == 0)
          if (strcmp(attributes[i].attr_name,"vy_none") != 0)
             printf("%s ",argv[0]);
  }
  return NULL;
}
char *new_info(int argc,char**argv) {
  int len;
  if (argc == 2) {
     if (strcmp(argv[0],"") == 0) ;
     else {
       attributes[num_attrs].name = (char*)malloc(strlen(argv[1])+1);
       strcpy(attributes[num_attrs].name, argv[1]);
       attributes[num_attrs].attr_name = (char*)malloc(strlen(argv[0]));
       len =strlen(argv[0]);
       argv[0][len-1] = '\0';
       (argv[0])++;
       strcpy(attributes[num_attrs].attr_name,argv[0]);
       attributes[num_attrs].special = -1;
       num_attrs++;
     }
  }
  return NULL;
}

main()
{
  if (yyparse() != 0) {fprintf(stderr,"exiting"); exit(1); }
  union_f = 0;
  nyprint(myprint,FIND_UNION,NY_SELECT,NY_NORMAL);
  if (union_f)  {
    nyprint(myprint,EXTEND,NY_OPEN,NY_NORMAL);
  }
  else /* fix default case */ {
    nyprint(myprint,DEFAULT,NY_OPEN,NY_NORMAL);
  }
}
static const yytabelem yyexca[] ={
-1, 1,
	0, -1,
	-2, 0,
	};
# define YYNPROD 64
# define YYLAST 370
static const yytabelem yyact[]={

    23,    46,    25,    85,    55,    28,    57,    34,    35,    31,
    29,    22,    30,    44,    32,    45,    41,    65,    44,    66,
    45,    42,    39,    40,    54,    71,    33,    26,    24,    27,
    23,    54,    25,    81,    51,    28,    80,    34,    35,    31,
    29,    22,    30,    15,    32,    79,    61,    72,    53,    83,
     3,    84,    59,    14,    78,    18,    33,    26,    24,    27,
    23,    16,    25,     4,    69,    28,    52,    34,    35,    31,
    29,    22,    30,     2,    32,     1,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,    33,    26,    24,    27,
    38,    60,    94,    62,    63,     0,     0,    23,    82,    25,
    58,    70,    28,     0,    34,    35,    31,    29,    22,    30,
     0,    32,     0,    68,     0,    77,    74,    75,     0,     0,
    38,     0,    92,    33,    26,    24,    27,    23,    90,    25,
     0,    17,    28,    89,    34,    35,    31,    29,    22,    30,
    93,    32,     0,    88,    86,     0,    87,    91,    56,     0,
    38,     0,    76,    33,    26,    24,    27,    12,     6,     8,
     9,     7,    10,    11,     0,    13,     0,    43,     5,    12,
     6,     8,     9,     7,    10,    11,    47,    48,    49,    50,
     5,     0,     0,     0,     0,     0,     0,    38,     0,    73,
    56,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    56,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    64,     0,     0,     0,    67,     0,     0,    38,     0,     0,
     0,     0,     0,    56,     0,     0,     0,     0,     0,     0,
     0,    41,     0,    36,    37,     0,     0,    39,    40,     0,
    19,    20,    21,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,    41,     0,    36,    37,     0,     0,    39,    40,     0,
    19,    20,    21,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,    41,     0,    36,    37,     0,     0,    39,    40,     0,
    19,    20,    21,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,    41,     0,
    36,    37,     0,     0,    39,    40,     0,    19,    20,    21,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,    41,     0,
    36,    37,     0,     0,    39,    40,     0,    19,    20,    21 };
static const yytabelem yypact[]={

   -88,-10000000,  -100,-10000000,-10000000,    94,  -251,  -271,  -246,  -246,
  -246,  -246,   -89,  -233,-10000000,  -265,    94,-10000000,-10000000,-10000000,
-10000000,  -258,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,
-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,    94,     0,
     0,     0,  -246,  -247,-10000000,-10000000,  -246,  -247,  -247,  -247,
  -247,    94,  -240,-10000000,   -11,-10000000,-10000000,-10000000,    64,-10000000,
  -248,  -248,-10000000,-10000000,  -247,-10000000,-10000000,  -247,    27,-10000000,
-10000000,    94,-10000000,-10000000,   -57,-10000000,-10000000,-10000000,   -26,  -120,
     0,-10000000,-10000000,-10000000,-10000000,    -3,-10000000,-10000000,-10000000,-10000000,
  -120,   -33,-10000000,-10000000,-10000000 };
static const yytabelem yypgo[]={

     0,    75,    73,    66,    64,    50,    63,    43,   167,    61,
   131,    55,    52,    48,    54,    45,    49,    51 };
static const yytabelem yyr1[]={

     0,     1,     2,     2,     5,     5,     6,     6,     6,     6,
     6,     6,     6,     6,     8,     8,     8,     8,     4,     4,
     7,     7,    10,    10,    10,    10,    10,    10,    10,    10,
    10,    10,    10,    10,    10,    10,    10,    10,    10,    10,
    10,    10,    10,     9,     9,    11,    11,    11,    12,    12,
    12,     3,     3,    13,    14,    14,    16,    16,    16,    15,
    15,    17,    17,    17 };
static const yytabelem yyr2[]={

     0,     9,     5,     3,     3,     7,     7,     5,     7,     5,
     5,     5,     5,     9,     5,     5,     3,     3,     1,     5,
     3,     1,     3,     3,     3,     5,     3,     3,     3,     3,
     3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
     3,     3,     7,     5,     3,     5,     5,     5,     9,     5,
     1,     5,     3,     9,     9,     5,     1,     7,     5,     5,
     1,     3,     3,     3 };
static const yytabelem yychk[]={

-10000000,    -1,    -2,    -5,    -6,   268,   258,   261,   259,   260,
   262,   263,   257,   265,    -5,    -7,    -9,   -10,   -11,   273,
   274,   275,    44,    33,    61,    35,    60,    62,    38,    43,
    45,    42,    47,    59,    40,    41,   266,   267,   123,   270,
   271,   264,   272,    -8,   264,   266,   272,    -8,    -8,    -8,
    -8,   123,    -3,   -13,   264,   269,   -10,   264,    -9,   -12,
    91,    46,   -12,   -12,    -8,   264,   266,    -8,    -9,    -4,
   -13,   265,    58,   125,   -11,   -11,   125,    -7,   -14,   -15,
    93,    59,   124,   -16,   -17,   123,   264,   266,   263,   -12,
   -15,    -9,   125,   -16,   125 };
static const yytabelem yydef[]={

     0,    -2,     0,     3,     4,    21,     0,     0,     0,     0,
     0,     0,     0,     0,     2,     0,    20,    44,    22,    23,
    24,     0,    26,    27,    28,    29,    30,    31,    32,    33,
    34,    35,    36,    37,    38,    39,    40,    41,     0,    50,
    50,    50,     0,     7,    16,    17,     0,     9,    10,    11,
    12,     0,    18,    52,     0,     5,    43,    25,     0,    45,
     0,     0,    46,    47,     6,    14,    15,     8,     0,     1,
    51,    21,    60,    42,     0,    49,    13,    19,     0,    56,
    50,    53,    60,    55,    59,     0,    61,    62,    63,    48,
    56,     0,    58,    54,    57 };
typedef struct
#ifdef __cplusplus
	yytoktype
#endif
{ char *t_name; int t_val; } yytoktype;
#ifndef YYDEBUG
#	define YYDEBUG	0	/* don't allow debugging */
#endif

#if YYDEBUG

yytoktype yytoks[] =
{
	"UNION_T",	257,
	"TOKEN_T",	258,
	"LEFT_T",	259,
	"RIGHT_T",	260,
	"TYPE_T",	261,
	"NONASSOC_T",	262,
	"PREC_T",	263,
	"NAME",	264,
	"DIVIDER",	265,
	"CHAR",	266,
	"STRING",	267,
	"START_C",	268,
	"STOP_C",	269,
	"LHS",	270,
	"RHS",	271,
	"BRACKET_KEYWORD",	272,
	"POUND_KEYWORD",	273,
	"KEYWORD",	274,
	"SPECIAL_KEYWORD",	275,
	"-unknown-",	-1	/* ends search */
};

char * yyreds[] =
{
	"-no such reduction-",
	"yacc_spec : beginning DIVIDER rule_list ending",
	"beginning : beginning beginning_elem",
	"beginning : beginning_elem",
	"beginning_elem : yacc_info",
	"beginning_elem : START_C opt_yacc_rest STOP_C",
	"yacc_info : TOKEN_T BRACKET_KEYWORD token_list",
	"yacc_info : TOKEN_T token_list",
	"yacc_info : TYPE_T BRACKET_KEYWORD token_list",
	"yacc_info : LEFT_T token_list",
	"yacc_info : RIGHT_T token_list",
	"yacc_info : NONASSOC_T token_list",
	"yacc_info : PREC_T token_list",
	"yacc_info : UNION_T '{' yacc_rest '}'",
	"token_list : token_list NAME",
	"token_list : token_list CHAR",
	"token_list : NAME",
	"token_list : CHAR",
	"ending : /* empty */",
	"ending : DIVIDER opt_yacc_rest",
	"opt_yacc_rest : yacc_rest",
	"opt_yacc_rest : /* empty */",
	"yacc_elem : yacc_variable_name",
	"yacc_elem : POUND_KEYWORD",
	"yacc_elem : KEYWORD",
	"yacc_elem : SPECIAL_KEYWORD NAME",
	"yacc_elem : ','",
	"yacc_elem : '!'",
	"yacc_elem : '='",
	"yacc_elem : '#'",
	"yacc_elem : '<'",
	"yacc_elem : '>'",
	"yacc_elem : '&'",
	"yacc_elem : '+'",
	"yacc_elem : '-'",
	"yacc_elem : '*'",
	"yacc_elem : '/'",
	"yacc_elem : ';'",
	"yacc_elem : '('",
	"yacc_elem : ')'",
	"yacc_elem : CHAR",
	"yacc_elem : STRING",
	"yacc_elem : '{' yacc_rest '}'",
	"yacc_rest : yacc_rest yacc_elem",
	"yacc_rest : yacc_elem",
	"yacc_variable_name : LHS opt_yacc_modifier",
	"yacc_variable_name : RHS opt_yacc_modifier",
	"yacc_variable_name : NAME opt_yacc_modifier",
	"opt_yacc_modifier : '[' yacc_variable_name ']' opt_yacc_modifier",
	"opt_yacc_modifier : '.' yacc_variable_name",
	"opt_yacc_modifier : /* empty */",
	"rule_list : rule_list rule",
	"rule_list : rule",
	"rule : NAME ':' rules ';'",
	"rules : rules '|' rule_body opt_c",
	"rules : rule_body opt_c",
	"opt_c : /* empty */",
	"opt_c : '{' yacc_rest '}'",
	"opt_c : '{' '}'",
	"rule_body : rule_body rule_elem",
	"rule_body : /* empty */",
	"rule_elem : NAME",
	"rule_elem : CHAR",
	"rule_elem : PREC_T",
};
#endif /* YYDEBUG */
# line	1 "/usr/ccs/bin/yaccpar"
/*
 * Copyright (c) 1993 by Sun Microsystems, Inc.
 */

#pragma ident	"@(#)yaccpar	6.14	97/01/16 SMI"

/*
** Skeleton parser driver for yacc output
*/

/*
** yacc user known macros and defines
*/
#define YYERROR		goto yyerrlab
#define YYACCEPT	return(0)
#define YYABORT		return(1)
#define YYBACKUP( newtoken, newvalue )\
{\
	if ( yychar >= 0 || ( yyr2[ yytmp ] >> 1 ) != 1 )\
	{\
		yyerror( "syntax error - cannot backup" );\
		goto yyerrlab;\
	}\
	yychar = newtoken;\
	yystate = *yyps;\
	yylval = newvalue;\
	goto yynewstate;\
}
#define YYRECOVERING()	(!!yyerrflag)
#define YYNEW(type)	malloc(sizeof(type) * yynewmax)
#define YYCOPY(to, from, type) \
	(type *) memcpy(to, (char *) from, yymaxdepth * sizeof (type))
#define YYENLARGE( from, type) \
	(type *) realloc((char *) from, yynewmax * sizeof(type))
#ifndef YYDEBUG
#	define YYDEBUG	1	/* make debugging available */
#endif

/*
** user known globals
*/
int yydebug;			/* set to 1 to get debugging */

/*
** driver internal defines
*/
#define YYFLAG		(-10000000)

/*
** global variables used by the parser
*/
YYSTYPE *yypv;			/* top of value stack */
int *yyps;			/* top of state stack */

int yystate;			/* current state */
int yytmp;			/* extra var (lasts between blocks) */

int yynerrs;			/* number of errors */
int yyerrflag;			/* error recovery flag */
int yychar;			/* current input token number */



#ifdef YYNMBCHARS
#define YYLEX()		yycvtok(yylex())
/*
** yycvtok - return a token if i is a wchar_t value that exceeds 255.
**	If i<255, i itself is the token.  If i>255 but the neither 
**	of the 30th or 31st bit is on, i is already a token.
*/
#if defined(__STDC__) || defined(__cplusplus)
int yycvtok(int i)
#else
int yycvtok(i) int i;
#endif
{
	int first = 0;
	int last = YYNMBCHARS - 1;
	int mid;
	wchar_t j;

	if(i&0x60000000){/*Must convert to a token. */
		if( yymbchars[last].character < i ){
			return i;/*Giving up*/
		}
		while ((last>=first)&&(first>=0)) {/*Binary search loop*/
			mid = (first+last)/2;
			j = yymbchars[mid].character;
			if( j==i ){/*Found*/ 
				return yymbchars[mid].tvalue;
			}else if( j<i ){
				first = mid + 1;
			}else{
				last = mid -1;
			}
		}
		/*No entry in the table.*/
		return i;/* Giving up.*/
	}else{/* i is already a token. */
		return i;
	}
}
#else/*!YYNMBCHARS*/
#define YYLEX()		yylex()
#endif/*!YYNMBCHARS*/

/*
** yyparse - return 0 if worked, 1 if syntax error not recovered from
*/
#if defined(__STDC__) || defined(__cplusplus)
int yyparse(void)
#else
int yyparse()
#endif
{
	register YYSTYPE *yypvt = 0;	/* top of value stack for $vars */

#if defined(__cplusplus) || defined(lint)
/*
	hacks to please C++ and lint - goto's inside
	switch should never be executed
*/
	static int __yaccpar_lint_hack__ = 0;
	switch (__yaccpar_lint_hack__)
	{
		case 1: goto yyerrlab;
		case 2: goto yynewstate;
	}
#endif

	/*
	** Initialize externals - yyparse may be called more than once
	*/
	yypv = &yyv[-1];
	yyps = &yys[-1];
	yystate = 0;
	yytmp = 0;
	yynerrs = 0;
	yyerrflag = 0;
	yychar = -1;

#if YYMAXDEPTH <= 0
	if (yymaxdepth <= 0)
	{
		if ((yymaxdepth = YYEXPAND(0)) <= 0)
		{
			yyerror("yacc initialization error");
			YYABORT;
		}
	}
#endif

	{
		register YYSTYPE *yy_pv;	/* top of value stack */
		register int *yy_ps;		/* top of state stack */
		register int yy_state;		/* current state */
		register int  yy_n;		/* internal state number info */
	goto yystack;	/* moved from 6 lines above to here to please C++ */

		/*
		** get globals into registers.
		** branch to here only if YYBACKUP was called.
		*/
	yynewstate:
		yy_pv = yypv;
		yy_ps = yyps;
		yy_state = yystate;
		goto yy_newstate;

		/*
		** get globals into registers.
		** either we just started, or we just finished a reduction
		*/
	yystack:
		yy_pv = yypv;
		yy_ps = yyps;
		yy_state = yystate;

		/*
		** top of for (;;) loop while no reductions done
		*/
	yy_stack:
		/*
		** put a state and value onto the stacks
		*/
#if YYDEBUG
		/*
		** if debugging, look up token value in list of value vs.
		** name pairs.  0 and negative (-1) are special values.
		** Note: linear search is used since time is not a real
		** consideration while debugging.
		*/
		if ( yydebug )
		{
			register int yy_i;

			printf( "State %d, token ", yy_state );
			if ( yychar == 0 )
				printf( "end-of-file\n" );
			else if ( yychar < 0 )
				printf( "-none-\n" );
			else
			{
				for ( yy_i = 0; yytoks[yy_i].t_val >= 0;
					yy_i++ )
				{
					if ( yytoks[yy_i].t_val == yychar )
						break;
				}
				printf( "%s\n", yytoks[yy_i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ++yy_ps >= &yys[ yymaxdepth ] )	/* room on stack? */
		{
			/*
			** reallocate and recover.  Note that pointers
			** have to be reset, or bad things will happen
			*/
			int yyps_index = (yy_ps - yys);
			int yypv_index = (yy_pv - yyv);
			int yypvt_index = (yypvt - yyv);
			int yynewmax;
#ifdef YYEXPAND
			yynewmax = YYEXPAND(yymaxdepth);
#else
			yynewmax = 2 * yymaxdepth;	/* double table size */
			if (yymaxdepth == YYMAXDEPTH)	/* first time growth */
			{
				char *newyys = (char *)YYNEW(int);
				char *newyyv = (char *)YYNEW(YYSTYPE);
				if (newyys != 0 && newyyv != 0)
				{
					yys = YYCOPY(newyys, yys, int);
					yyv = YYCOPY(newyyv, yyv, YYSTYPE);
				}
				else
					yynewmax = 0;	/* failed */
			}
			else				/* not first time */
			{
				yys = YYENLARGE(yys, int);
				yyv = YYENLARGE(yyv, YYSTYPE);
				if (yys == 0 || yyv == 0)
					yynewmax = 0;	/* failed */
			}
#endif
			if (yynewmax <= yymaxdepth)	/* tables not expanded */
			{
				yyerror( "yacc stack overflow" );
				YYABORT;
			}
			yymaxdepth = yynewmax;

			yy_ps = yys + yyps_index;
			yy_pv = yyv + yypv_index;
			yypvt = yyv + yypvt_index;
		}
		*yy_ps = yy_state;
		*++yy_pv = yyval;

		/*
		** we have a new state - find out what to do
		*/
	yy_newstate:
		if ( ( yy_n = yypact[ yy_state ] ) <= YYFLAG )
			goto yydefault;		/* simple state */
#if YYDEBUG
		/*
		** if debugging, need to mark whether new token grabbed
		*/
		yytmp = yychar < 0;
#endif
		if ( ( yychar < 0 ) && ( ( yychar = nylex() ) < 0 ) )
			yychar = 0;		/* reached EOF */
#if YYDEBUG
		if ( yydebug && yytmp )
		{
			register int yy_i;

			printf( "Received token " );
			if ( yychar == 0 )
				printf( "end-of-file\n" );
			else if ( yychar < 0 )
				printf( "-none-\n" );
			else
			{
				for ( yy_i = 0; yytoks[yy_i].t_val >= 0;
					yy_i++ )
				{
					if ( yytoks[yy_i].t_val == yychar )
						break;
				}
				printf( "%s\n", yytoks[yy_i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ( ( yy_n += yychar ) < 0 ) || ( yy_n >= YYLAST ) )
			goto yydefault;
		if ( yychk[ yy_n = yyact[ yy_n ] ] == yychar )	/*valid shift*/
		{
			yychar = -1;
			yyval = yylval;
			yy_state = yy_n;
			if ( yyerrflag > 0 )
				yyerrflag--; nyipop();
			goto yy_stack;
		}

	yydefault:
		if ( ( yy_n = yydef[ yy_state ] ) == -2 )
		{
#if YYDEBUG
			yytmp = yychar < 0;
#endif
			if ( ( yychar < 0 ) && ( ( yychar = nylex() ) < 0 ) )
				yychar = 0;		/* reached EOF */
#if YYDEBUG
			if ( yydebug && yytmp )
			{
				register int yy_i;

				printf( "Received token " );
				if ( yychar == 0 )
					printf( "end-of-file\n" );
				else if ( yychar < 0 )
					printf( "-none-\n" );
				else
				{
					for ( yy_i = 0;
						yytoks[yy_i].t_val >= 0;
						yy_i++ )
					{
						if ( yytoks[yy_i].t_val
							== yychar )
						{
							break;
						}
					}
					printf( "%s\n", yytoks[yy_i].t_name );
				}
			}
#endif /* YYDEBUG */
			/*
			** look through exception table
			*/
			{
				register const int *yyxi = yyexca;

				while ( ( *yyxi != -1 ) ||
					( yyxi[1] != yy_state ) )
				{
					yyxi += 2;
				}
				while ( ( *(yyxi += 2) >= 0 ) &&
					( *yyxi != yychar ) )
					;
				if ( ( yy_n = yyxi[1] ) < 0 )
					YYACCEPT;
			}
		}

		/*
		** check for syntax error
		*/
		if ( yy_n == 0 )	/* have an error */
		{
			/* no worry about speed here! */
			switch ( yyerrflag )
			{
			case 0:		/* new error */
				yyerror( "syntax error" );
				goto skip_init;
			yyerrlab:
				/*
				** get globals into registers.
				** we have a user generated syntax type error
				*/
				yy_pv = yypv;
				yy_ps = yyps;
				yy_state = yystate;
			skip_init:
				yynerrs++;
				/* FALLTHRU */
			case 1:
			case 2:		/* incompletely recovered error */
					/* try again... */
				yyerrflag = 3;
				/*
				** find state where "error" is a legal
				** shift action
				*/
				while ( yy_ps >= yys )
				{
					yy_n = yypact[ *yy_ps ] + YYERRCODE;
					if ( yy_n >= 0 && yy_n < YYLAST &&
						yychk[yyact[yy_n]] == YYERRCODE)					{
						/*
						** simulate shift of "error"
						*/
						yy_state = yyact[ yy_n ];
						goto yy_stack;
					}
					/*
					** current state has no shift on
					** "error", pop stack
					*/
#if YYDEBUG
#	define _POP_ "Error recovery pops state %d, uncovers state %d\n"
					if ( yydebug )
						printf( _POP_, *yy_ps,
							yy_ps[-1] );
#	undef _POP_
#endif
					yy_ps--;
					yy_pv--;
				}
				/*
				** there is no state on stack with "error" as
				** a valid shift.  give up.
				*/
				YYABORT;
			case 3:		/* no shift yet; eat a token */
#if YYDEBUG
				/*
				** if debugging, look up token in list of
				** pairs.  0 and negative shouldn't occur,
				** but since timing doesn't matter when
				** debugging, it doesn't hurt to leave the
				** tests here.
				*/
				if ( yydebug )
				{
					register int yy_i;

					printf( "Error recovery discards " );
					if ( yychar == 0 )
						printf( "token end-of-file\n" );
					else if ( yychar < 0 )
						printf( "token -none-\n" );
					else
					{
						for ( yy_i = 0;
							yytoks[yy_i].t_val >= 0;
							yy_i++ )
						{
							if ( yytoks[yy_i].t_val
								== yychar )
							{
								break;
							}
						}
						printf( "token %s\n",
							yytoks[yy_i].t_name );
					}
				}
#endif /* YYDEBUG */
				if ( yychar == 0 )	/* reached EOF. quit */
					YYABORT;
				yychar = -1;
				goto yy_newstate;
			}
		}/* end if ( yy_n == 0 ) */
		/*
		** reduction by production yy_n
		** put stack tops, etc. so things right after switch
		*/
#if YYDEBUG
		/*
		** if debugging, print the string that is the user's
		** specification of the reduction which is just about
		** to be done.
		*/
		if ( yydebug )
			printf( "Reduce by (%d) \"%s\"\n",
				yy_n, yyreds[ yy_n ] );
#endif
		yytmp = yy_n;			/* value to switch over */
		yypvt = yy_pv;			/* $vars top of value stack */
		/*
		** Look in goto table for next state
		** Sorry about using yy_state here as temporary
		** register variable, but why not, if it works...
		** If yyr2[ yy_n ] doesn't have the low order bit
		** set, then there is no action to be done for
		** this reduction.  So, no saving & unsaving of
		** registers done.  The only difference between the
		** code just after the if and the body of the if is
		** the goto yy_stack in the body.  This way the test
		** can be made before the choice of what to do is needed.
		*/
		{
			/* length of production doubled with extra bit */
			register int yy_len = yyr2[ yy_n ];

			if ( !( yy_len & 01 ) )
			{
				yy_len >>= 1;
				yyval = ( yy_pv -= yy_len )[1];	/* $$ = $1 */
				yy_state = yypgo[ yy_n = yyr1[ yy_n ] ] +
					*( yy_ps -= yy_len ) + 1;
				if ( yy_state >= YYLAST ||
					yychk[ yy_state =
					yyact[ yy_state ] ] != -yy_n )
				{
					yy_state = yyact[ yypgo[ yy_n ] ];
				}
				goto yy_stack;
			}
			yy_len >>= 1;
			yyval = ( yy_pv -= yy_len )[1];	/* $$ = $1 */
			yy_state = yypgo[ yy_n = yyr1[ yy_n ] ] +
				*( yy_ps -= yy_len ) + 1;
			if ( yy_state >= YYLAST ||
				yychk[ yy_state = yyact[ yy_state ] ] != -yy_n )
			{
				yy_state = yyact[ yypgo[ yy_n ] ];
			}
		}
					/* save until reenter driver code */
		yystate = yy_state;
		yyps = yy_ps;
		yypv = yy_pv;
	}
	/*
	** code supplied by user is placed in this switch
	*/
	switch( yytmp )
	{
		
case 1:
# line 45 "./ny.temp.y"
{  ny__trans(128); ny__beg();  ny__orderp(1,0,0,1,0);  ny__end(); 
                 ny__trans(1); ny__beg();    ny__orderp(1,0,0,1,0);  ny__begf(); ny__orderf(0,output_default_types);  ny__orders("\n");  
                 ny__orders("%type <vyacc_attrs>");  ny__orderp(1,4,1,0,0);  ny__orders(" ");  
                 ny__orderp(3,2,1,0,0);  ny__orders("\n");  ny__orderp(2,0,1,1,0);  ny__orders("\n");   ny__orderp(3,0,0,1,0); ny__orderp(4,0,0,1,0);  ny__end(); 
		 ny__trans(8); ny__beg();  ny__orderp(1,16,1,0,0);  
		  ny__orderp(1,0,0,1,0); ny__orderp(2,0,1,1,0);  ny__orders("\n");   ny__orderp(3,0,0,1,0);  ny__orderp(4,0,0,1,0);  ny__begf(); ny__orderf(0,dump_attrs);  ny__end(); 
		 ny__squish(4,0); } break;
case 2:
# line 54 "./ny.temp.y"
{  ny__squish(2,0); } break;
case 3:
# line 55 "./ny.temp.y"
{  ny__squish(1,0); } break;
case 4:
# line 58 "./ny.temp.y"
{  ny__trans(9); ny__beg();   ny__orderp(1,0,0,1,0); ny__orders("\n");  ny__end(); 

		 ny__squish(1,0); } break;
case 5:
# line 61 "./ny.temp.y"
{  ny__trans(128); ny__beg();   ny__end(); 
		 ny__trans(68); ny__beg();   ny__end(); 
		 ny__trans(16); ny__beg();   ny__end(); 
		 ny__trans(9); ny__beg();  ny__orderp(1,0,1,1,0);  ny__orders("\n");   ny__orderp(2,0,0,1,0); ny__orders("\n");  ny__orderp(3,0,1,1,0);  ny__orders("\n");  ny__end(); 
		 ny__squish(3,0); } break;
case 6:
# line 68 "./ny.temp.y"
{  ny__trans(128); ny__beg();   ny__end(); 
		 ny__trans(16); ny__beg();   ny__decl(&attr_type);   ny__assignp(&attr_type,2,0,1,1,0);   ny__orderp(3,0,0,0,0);  ny__end(); 
		 ny__trans(68); ny__beg();   ny__orderp(3,0,0,0,0);  ny__end(); 
		 ny__trans(1); ny__beg();   ny__orderp(1,0,0,1,0); ny__orders(" ");   ny__orderp(2,0,0,1,0); ny__orders(" ");  ny__orderp(3,0,0,1,0);  ny__end(); 
		 ny__trans(8); ny__beg();   ny__orderp(1,0,0,1,0); ny__orders(" <vyacc_attrs> ");  ny__orderp(3,0,0,1,0);  ny__end(); 

		 ny__squish(3,0); } break;
case 7:
# line 75 "./ny.temp.y"
{  ny__trans(128); ny__beg();   ny__end(); 
		 ny__trans(16); ny__beg();   ny__decl(&attr_type);   ny__assigns(&attr_type,"_vy_none_");  ny__orderp(2,0,0,0,0);  ny__end(); 
		 ny__trans(68); ny__beg();   ny__orderp(2,0,0,0,0);  ny__end(); 
		 ny__trans(9); ny__beg();   ny__orderp(1,0,0,1,0); ny__orders(" ");   ny__orderp(2,0,0,1,0);  ny__end(); 

		 ny__squish(2,0); } break;
case 8:
# line 81 "./ny.temp.y"
{  ny__trans(128); ny__beg();   ny__end(); 
		 ny__trans(16); ny__beg();   ny__decl(&attr_type);   ny__assignp(&attr_type,2,0,1,1,0);  ny__orderp(3,0,0,0,0);  ny__end(); 
		 ny__trans(68); ny__beg();   ny__end(); 
		 ny__trans(1); ny__beg();   ny__orderp(1,0,0,1,0); ny__orders(" ");   ny__orderp(2,0,0,1,0);  ny__orderp(3,0,0,1,0);  ny__orderp(4,0,0,1,0); ny__orders(" ");  ny__orderp(5,0,0,1,0);  ny__end(); 
		 ny__trans(8); ny__beg();  ny__orderp(1,0,1,1,0);  ny__orders(" <vyacc_attrs> ");  ny__orderp(3,0,0,1,0);  ny__end(); 

		 ny__squish(3,0); } break;
case 9:
# line 88 "./ny.temp.y"
{  ny__trans(128); ny__beg();   ny__end(); 
		 ny__trans(16); ny__beg();   ny__end(); 
		 ny__trans(68); ny__beg();   ny__end(); 
		 ny__trans(9); ny__beg();   ny__orderp(1,0,0,1,0); ny__orders(" ");   ny__orderp(2,0,0,1,0);  ny__end(); 

		 ny__squish(2,0); } break;
case 10:
# line 94 "./ny.temp.y"
{  ny__trans(128); ny__beg();   ny__end(); 
		 ny__trans(16); ny__beg();   ny__end(); 
		 ny__trans(68); ny__beg();   ny__end(); 
		 ny__trans(9); ny__beg();   ny__orderp(1,0,0,1,0); ny__orders(" ");   ny__orderp(2,0,0,1,0);  ny__end(); 

		 ny__squish(2,0); } break;
case 11:
# line 100 "./ny.temp.y"
{  ny__trans(128); ny__beg();   ny__end(); 
		 ny__trans(16); ny__beg();   ny__end(); 
		 ny__trans(68); ny__beg();   ny__end(); 
		 ny__trans(9); ny__beg();   ny__orderp(1,0,0,1,0); ny__orders(" ");   ny__orderp(2,0,0,1,0);  ny__end(); 

		 ny__squish(2,0); } break;
case 12:
# line 106 "./ny.temp.y"
{  ny__trans(128); ny__beg();   ny__end(); 
		 ny__trans(16); ny__beg();   ny__end(); 
		 ny__trans(68); ny__beg();   ny__end(); 
		 ny__trans(9); ny__beg();   ny__orderp(1,0,0,1,0); ny__orders(" ");   ny__orderp(2,0,0,1,0);  ny__end(); 

		 ny__squish(2,0); } break;
case 13:
# line 112 "./ny.temp.y"
{  ny__trans(128); ny__beg();   ny__begf(); ny__orderf(0,union_found);   ny__end(); 
		 ny__trans(16); ny__beg();   ny__end(); 
		 ny__trans(68); ny__beg();   ny__end(); 
		 ny__trans(1); ny__beg();   ny__orderp(1,0,0,1,0); ny__orders(" ");   ny__orderp(2,0,0,1,0); ny__orders("\n");   ny__orderp(3,0,0,1,0); ny__orderp(4,0,0,1,0);  ny__end(); 
		 ny__trans(8); ny__beg();  ny__orderp(3,32,1,0,0);  ny__orderp(1,0,1,1,0);  ny__orders(" ");  ny__orderp(2,0,1,1,0); 
		 ny__orders("\nstruct {\n");   ny__begf(); ny__orderf(0,output_spec);  ny__orderp(3,1,1,1,0); 
		 ny__orders("\n} vyacc_attrs;\n");  ny__orderp(4,0,1,1,0);  ny__orders("\n");   ny__end(); 
		 ny__squish(4,0); } break;
case 14:
# line 122 "./ny.temp.y"
{  ny__trans(16); ny__beg();   ny__orderp(1,0,0,1,0);  ny__begf();  ny__refer(&attr_type);  ny__comma(); ny__orderp(2,0,1,1,0); ny__orderf(2,new_info);   ny__end(); 
		 ny__trans(64); ny__beg();   ny__orderp(1,0,0,0,0);  ny__begf(); ny__orderp(2,0,1,1,0); ny__orderf(1,check_name);   ny__end(); 
		 ny__trans(4); ny__beg();   ny__orderp(1,0,0,0,0); ny__orders(" ");  ny__orderp(2,0,1,1,0);   ny__end(); 
		 ny__trans(9); ny__beg();   ny__orderp(1,0,0,1,0); ny__orders(" ");  ny__orderp(2,0,0,1,0);  ny__end(); 

		 ny__squish(2,0); } break;
case 15:
# line 128 "./ny.temp.y"
{  ny__trans(16); ny__beg();   ny__orderp(1,0,0,1,0);  ny__end(); 
		 ny__trans(68); ny__beg();   ny__orderp(1,0,0,0,0);  ny__end(); 
		 ny__trans(9); ny__beg();   ny__orderp(1,0,0,1,0); ny__orders(" ");  ny__orderp(2,0,0,1,0);  ny__end(); 

		 ny__squish(2,0); } break;
case 16:
# line 133 "./ny.temp.y"
{  ny__trans(16); ny__beg();   ny__begf();  ny__refer(&attr_type);  ny__comma(); ny__orderp(1,0,1,1,0); ny__orderf(2,new_info);   ny__end(); 
		 ny__trans(64); ny__beg();   ny__begf(); ny__orderp(1,0,1,1,0); ny__orderf(1,check_name);   ny__end(); 
		 ny__trans(4); ny__beg();  ny__orders(" ");  ny__orderp(1,0,1,1,0);   ny__end(); 

		 ny__squish(1,0); } break;
case 17:
# line 138 "./ny.temp.y"
{  ny__trans(16); ny__beg();   ny__end(); 
		 ny__trans(68); ny__beg();   ny__end(); 
		 ny__squish(1,0); } break;
case 18:
# line 143 "./ny.temp.y"
{  ny__squish(0,0); } break;
case 19:
# line 144 "./ny.temp.y"
{  ny__trans(9); ny__beg();   ny__orderp(1,0,0,1,0); ny__orders("\n");  ny__orderp(2,0,0,1,0);  ny__end(); 
		 ny__squish(2,0); } break;
case 20:
# line 148 "./ny.temp.y"
{  ny__squish(1,0); } break;
case 21:
# line 149 "./ny.temp.y"
{  ny__squish(0,0); } break;
case 22:
# line 152 "./ny.temp.y"
{  ny__trans(9); ny__beg();   ny__orderp(1,0,0,1,0); ny__orders(" ");  ny__end(); 
		 ny__squish(1,0); } break;
case 23:
# line 154 "./ny.temp.y"
{  ny__trans(9); ny__beg();   ny__orderp(1,0,0,1,0); ny__orders("\n");  ny__end(); 
		 ny__squish(1,0); } break;
case 24:
# line 156 "./ny.temp.y"
{  ny__trans(9); ny__beg();   ny__orderp(1,0,0,1,0); ny__orders(" ");  ny__end(); 
		 ny__squish(1,0); } break;
case 25:
# line 158 "./ny.temp.y"
{  ny__trans(32); ny__beg();   ny__begf(); ny__orderp(2,0,1,1,0); ny__orderf(1,special);   ny__end(); 
		 ny__trans(9); ny__beg();  ny__orders("int ");  ny__orderp(2,0,1,1,0);  ny__end(); 
		 ny__squish(2,0); } break;
case 26:
# line 161 "./ny.temp.y"
{  ny__squish(1,0); } break;
case 27:
# line 162 "./ny.temp.y"
{  ny__squish(1,0); } break;
case 28:
# line 163 "./ny.temp.y"
{  ny__squish(1,0); } break;
case 29:
# line 164 "./ny.temp.y"
{  ny__trans(9); ny__beg();  ny__orders("\n");  ny__orderp(1,0,0,1,0);  ny__end(); 
                 ny__squish(1,0); } break;
case 30:
# line 166 "./ny.temp.y"
{  ny__squish(1,0); } break;
case 31:
# line 167 "./ny.temp.y"
{  ny__squish(1,0); } break;
case 32:
# line 168 "./ny.temp.y"
{  ny__squish(1,0); } break;
case 33:
# line 169 "./ny.temp.y"
{  ny__squish(1,0); } break;
case 34:
# line 170 "./ny.temp.y"
{  ny__squish(1,0); } break;
case 35:
# line 171 "./ny.temp.y"
{  ny__squish(1,0); } break;
case 36:
# line 172 "./ny.temp.y"
{  ny__squish(1,0); } break;
case 37:
# line 173 "./ny.temp.y"
{  ny__trans(9); ny__beg();   ny__orderp(1,0,0,1,0); ny__orders("\n");  ny__end(); 
                 ny__squish(1,0); } break;
case 38:
# line 175 "./ny.temp.y"
{  ny__squish(1,0); } break;
case 39:
# line 176 "./ny.temp.y"
{  ny__squish(1,0); } break;
case 40:
# line 177 "./ny.temp.y"
{  ny__squish(1,0); } break;
case 41:
# line 178 "./ny.temp.y"
{  ny__squish(1,0); } break;
case 42:
# line 179 "./ny.temp.y"
{  ny__trans(9); ny__beg();   ny__orderp(1,0,0,1,0); ny__orders("\n");   ny__orderp(2,0,0,1,0);  ny__orderp(3,0,0,1,0); ny__orders("\n");   ny__end(); 
		 ny__squish(3,0); } break;
case 43:
# line 182 "./ny.temp.y"
{  ny__squish(2,0); } break;
case 44:
# line 183 "./ny.temp.y"
{  ny__squish(1,0); } break;
case 45:
# line 187 "./ny.temp.y"
{  ny__trans(1); ny__beg();   ny__orderp(1,0,0,1,0); ny__orders(".x[0]");   ny__end(); 
		 ny__trans(8); ny__beg();  ny__orderp(1,0,1,1,0);   ny__begf(); ny__orderp(1,0,1,1,0); ny__orderf(1,extended);   ny__orderp(2,0,0,1,0);  ny__end(); 
		 ny__squish(2,0); } break;
case 46:
# line 190 "./ny.temp.y"
{  ny__trans(1); ny__beg();   ny__orderp(1,0,0,1,0); ny__orders(".x[0]");   ny__end(); 
		 ny__trans(8); ny__beg();  ny__orderp(1,0,1,1,0);   ny__begf(); ny__orderp(1,0,1,1,0); ny__orderf(1,extended);    ny__orderp(2,0,0,1,0);  ny__end(); 
		 ny__squish(2,0); } break;
case 47:
# line 193 "./ny.temp.y"
{  ny__squish(2,0); } break;
case 48:
# line 196 "./ny.temp.y"
{  ny__squish(4,0); } break;
case 49:
# line 197 "./ny.temp.y"
{  ny__squish(2,0); } break;
case 50:
# line 198 "./ny.temp.y"
{  ny__squish(0,0); } break;
case 51:
# line 201 "./ny.temp.y"
{  ny__squish(2,0); } break;
case 52:
# line 202 "./ny.temp.y"
{  ny__squish(1,0); } break;
case 53:
# line 205 "./ny.temp.y"
{  ny__trans(2); ny__beg();  ny__orderp(1,0,1,1,0);  ny__orders(" ");   ny__end(); 
		 ny__trans(1); ny__beg();   ny__orderp(1,0,0,1,0); ny__orders(" ");   ny__orderp(2,0,0,1,0); ny__orders(" ");   ny__orderp(3,0,0,1,0); ny__orders("      ;\n");  ny__end(); 
		 ny__trans(8); ny__beg();   ny__begf(); ny__orderf(0,init_count);    ny__begf(); ny__orderp(1,0,1,1,0); ny__orderf(1,process);   ny__orderp(1,0,0,1,0); ny__orders(" ");   ny__orderp(2,0,0,1,0); ny__orders(" ");   ny__orderp(3,0,0,1,0); ny__orders("      ;\n");  ny__end(); 
		 ny__squish(4,0); } break;
case 54:
# line 211 "./ny.temp.y"
{  ny__trans(1); ny__beg();   ny__orderp(1,0,0,1,0); ny__orders("      |  ");  ny__orderp(3,0,0,1,0); ny__orders(" ");    ny__orderp(4,0,0,1,0); ny__orders("\n");  ny__end(); 
		 ny__trans(8); ny__beg();   ny__orderp(1,0,0,1,0); ny__orders("      |  ");   ny__begf(); ny__orderf(0,re_init_count);  ny__orderp(3,0,0,1,0); ny__orders(" ");    ny__orderp(4,0,0,1,0); ny__orders("\n");  ny__end(); 
		 ny__squish(4,0); } break;
case 55:
# line 214 "./ny.temp.y"
{  ny__trans(1); ny__beg();   ny__orderp(1,0,0,1,0); ny__orders(" ");   ny__orderp(2,0,0,1,0); ny__orders("\n");  ny__end(); 
		 ny__trans(8); ny__beg();   ny__begf(); ny__orderf(0,re_init_count);   ny__orderp(1,0,0,1,0); ny__orders(" ");   ny__orderp(2,0,0,1,0); ny__orders("\n");  ny__end(); 
		 ny__squish(2,0); } break;
case 56:
# line 219 "./ny.temp.y"
{  ny__trans(9); ny__beg();  ny__orders("{ }");  ny__end(); 
		 ny__squish(0,0); } break;
case 57:
# line 221 "./ny.temp.y"
{  ny__trans(8); ny__beg();  ny__orderp(1,0,1,1,0);   ny__orderp(2,0,0,1,0);  ny__begf(); ny__orderf(0,visual);  ny__orderp(3,0,1,1,0);   ny__end(); 
		 ny__squish(3,0); } break;
case 58:
# line 223 "./ny.temp.y"
{  ny__squish(2,0); } break;
case 59:
# line 226 "./ny.temp.y"
{  ny__trans(9); ny__beg();   ny__orderp(1,0,0,1,0); ny__orders(" ");  ny__orderp(2,0,0,1,0);  ny__end(); 
		 ny__squish(2,0); } break;
case 60:
# line 228 "./ny.temp.y"
{  ny__squish(0,0); } break;
case 61:
# line 231 "./ny.temp.y"
{  ny__trans(8); ny__beg();   ny__begf(); ny__orderp(1,0,1,1,0); ny__orderf(1,process);  ny__orderp(1,0,1,1,0);   ny__end(); 
		 ny__squish(1,0); } break;
case 62:
# line 233 "./ny.temp.y"
{  ny__trans(8); ny__beg();   ny__begf(); ny__orderp(1,0,1,1,0); ny__orderf(1,process);   ny__orderp(1,0,1,1,0);  ny__end(); 
		 ny__squish(1,0); } break;
case 63:
# line 235 "./ny.temp.y"
{  ny__squish(1,0); } break;
# line	531 "/usr/ccs/bin/yaccpar"
	}
	goto yystack;		/* reset registers in driver code */
}

