/***********************************************************************
 
 What This Is:      Graphic Parse Modual 
 Author:            Laura Deddens
 Email:             lelo@cats.ucsc.edu
 Last Modified:     5 September 1996
 
***********************************************************************/


#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <Xm/Xm.h>
#include <Xm/Form.h>
#include <Xm/PushB.h>
#include <Xm/DrawingA.h>
#include <Xm/SelectioB.h>
#include <Xm/ScrollBar.h>
#include <Xm/Separator.h>
#include <parseTree.h>
#include <parseTreeList.h>
#include <stepPar.h>
#include <graphicParse.h>


#define WIDTHOFSTACK                    75	/* number of pixals wide the drawn stack is */
#define STACKBOARDER                    25	/* number of pixals wide of the clear boarder of each side of the drawn stack */

#define ORGWIDTHOFWINDOW                600
#define ORGHEIGHTOFWINDOW		450
#define BUTTONHEIGHT                    25
#define SCROLLBARWIDTH                  20
#define WIDTHOFSTACKDRAWINGAREA         (WIDTHOFSTACK + (2 * STACKBOARDER))

#define ORGHEIGHTOFTREEDRAWINGAREA      (ORGHEIGHTOFWINDOW - BUTTONHEIGHT - SCROLLBARWIDTH)
#define ORGHEIGHTOFSTACKDRAWINGAREA     (ORGHEIGHTOFWINDOW - BUTTONHEIGHT)

#define ORGSTACKELEMENTHEIGHT		13	/* number of pixals allocated for the height of the name of the drawn stack element */
#define VALUEELEMENTHEIGHT		12	/* number of additional pixals needed for the height of each value of a drawn stack element */
#define STACKSTRINGXOFFSET		5	/* number of pixals to the right of the LEFTOfSTACK that strings get drawn */
#define STACKSTRINGYOFFSET		3	/* number of pixals above the bottom of a strings area that the string gets drawn */
#define BOTTOMOFSTACK           	(ORGHEIGHTOFSTACKDRAWINGAREA - 10)
#define LEFTOFSTACK                     STACKBOARDER
#define RIGHTOFSTACK                    (LEFTOFSTACK + WIDTHOFSTACK)

#define NODEHEIGHT                      20      /* number of pixals that a node should be drawn above its highest child in the tree */
#define NODEWIDTH                       75	/* number of pixals to the right of the previous leaf that a new leaf should be drawn */
#define LEFTOFTREE                      25
#define BOTTOMOFTREE                    (ORGHEIGHTOFTREEDRAWINGAREA - 10)

/* these values are used to set up the scroll bars */
#define TREEMAXX	20000
#define TREEMAXY	5000
#define STACKMAXY	5000
#define TREEMINX	0
#define TREEMINY	0
#define STACKMINY	0
 
/* these values are used by ButtonCB */
#define START           1
#define STEP            2
#define MULTISTEP       3
#define GO              4
#define QUIT            5
 
/* these values are used by DialogCB */
#define OK      1
#define CANCEL  2

/* these values are used by ScrollCB */
#define TREEHORIZONTAL	1
#define TREEVERTICAL	2
#define STACKVERTICAL	3

/* these values are used by ResizeCB and ExposeCB */
#define TREE	1
#define STACK	2


int gNumValues;

XmStringCharSet gCharSet = XmSTRING_DEFAULT_CHARSET;
Widget gStartButton;
Widget gStepButton;
Widget gMultiStepButton;
Widget gGoButton;
Widget gQuitButton;
Widget gTreeDrawingArea;
Widget gStackDrawingArea;
Widget gDialog;
Widget gTreeHorizontalScroll;
Widget gTreeVerticalScroll;
Widget gStackScroll;
GC gGC;

int			gLeafNumber	= 0;	/* each time a new leaf is created this need to be incremented
                                                   so that we know how far right to place the next leaf */

ParseTreeListHdl	gParseTreeList	= NULL;	/* a list of all the parentless parse trees so far in the order in which they are on the stack */

int 			gWindowYOffset	= 0;	/* when the window gets resized this global variable should be reset so that it reflexes how far
					         * above or below the original point that each thing should get drawn
					 	 */

/* each of these needs updating when a scroll bar get slid */
int gTreeDrawingXOffset = 0;
int gTreeDrawingYOffset = 0;
int gStackDrawingYOffset = 0;


void SetupGc(void);
void ButtonCB(Widget theWidget, int clientData, XtPointer callData);
void DialogCB(Widget theWidget, int clientData, XmSelectionBoxCallbackStruct *callData);
void ExposeCB(Widget theWidget, int clientData, XtPointer callData);
void ResizeCB(Widget theWidget, int clientData, XtPointer callData);
void ScrollCB(Widget theWidget, int clientData, XtPointer callData);
void DrawAll(void);
void DrawStack(void);
void DrawTrees(void);
void DrawParseTree(ParseTreeHdl tree);
void ConnectNodes(ParseTreeHdl highNode, ParseTreeHdl lowNode);


void MyMain(int argc, char *argv[])
   {
   Arg al[20];
   int ac;
   Widget topLevel,
          form,
          buttonDrawingSeparator,
          scrollScrollSeparator;
   XtAppContext context;

   /* create the toplevel shell */
   topLevel = XtAppInitialize(&context, "", NULL, 0, &argc, argv, NULL, NULL, 0);
 
   /* set window size. */
   ac = 0;
   XtSetArg(al[ac], XmNheight, ORGHEIGHTOFWINDOW); ac++;
   XtSetArg(al[ac], XmNwidth, ORGWIDTHOFWINDOW); ac++;
   XtSetValues(topLevel, al, ac);
 
   /* create a form to hold widgets */
   ac = 0;
   form = XmCreateForm(topLevel, "form", al, ac);
   XtManageChild(form);
 
   /* create the push buttons */
   ac = 0;
   XtSetArg(al[ac], XmNheight, BUTTONHEIGHT); ac++;
   XtSetArg(al[ac], XmNlabelString, XmStringCreate("Start", gCharSet)); ac++;
   XtSetArg(al[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
   XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
   gStartButton = XmCreatePushButton(form, "gStartButton", al, ac);
   XtManageChild(gStartButton);
   XtAddCallback(gStartButton, XmNactivateCallback, (XtCallbackProc)ButtonCB, (XtPointer)START);
 
   ac = 0;
   XtSetArg(al[ac], XmNheight, BUTTONHEIGHT); ac++;
   XtSetArg(al[ac], XmNlabelString, XmStringCreate("Step", gCharSet)); ac++;
   XtSetArg(al[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
   XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
   XtSetArg(al[ac], XmNleftWidget, gStartButton); ac++;
   gStepButton = XmCreatePushButton(form, "gStepButton", al, ac);
   XtManageChild(gStepButton);
   XtSetSensitive(gStepButton, FALSE);
   XtAddCallback(gStepButton, XmNactivateCallback, (XtCallbackProc)ButtonCB, (XtPointer)STEP);
 
   ac = 0;
   XtSetArg(al[ac], XmNheight, BUTTONHEIGHT); ac++;
   XtSetArg(al[ac], XmNlabelString, XmStringCreate("Multi Step", gCharSet)); ac++;
   XtSetArg(al[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
   XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
   XtSetArg(al[ac], XmNleftWidget, gStepButton); ac++;
   gMultiStepButton = XmCreatePushButton(form, "gMultiStepButton", al, ac);
   XtManageChild(gMultiStepButton);
   XtSetSensitive(gMultiStepButton, FALSE);
   XtAddCallback(gMultiStepButton, XmNactivateCallback, (XtCallbackProc)ButtonCB, (XtPointer)MULTISTEP);
 
   ac = 0;
   XtSetArg(al[ac], XmNheight, BUTTONHEIGHT); ac++;
   XtSetArg(al[ac], XmNlabelString, XmStringCreate("Go", gCharSet)); ac++;
   XtSetArg(al[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
   XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
   XtSetArg(al[ac], XmNleftWidget, gMultiStepButton); ac++;
   gGoButton = XmCreatePushButton(form, "gGoButton", al, ac);
   XtManageChild(gGoButton);
   XtSetSensitive(gGoButton, FALSE);
   XtAddCallback(gGoButton, XmNactivateCallback, (XtCallbackProc)ButtonCB, (XtPointer)GO);

   ac = 0;
   XtSetArg(al[ac], XmNheight, BUTTONHEIGHT); ac++;
   XtSetArg(al[ac], XmNlabelString, XmStringCreate("Quit", gCharSet)); ac++;
   XtSetArg(al[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
   XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
   XtSetArg(al[ac], XmNleftWidget, gGoButton); ac++;
   gQuitButton = XmCreatePushButton(form, "gQuitButton", al, ac);
   XtManageChild(gQuitButton);
   XtAddCallback(gQuitButton, XmNactivateCallback, (XtCallbackProc)ButtonCB, (XtPointer)QUIT);

   /* create a separator between the buttons and the drawing areas */
   ac = 0;
   XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
   XtSetArg(al[ac], XmNtopWidget, gStartButton); ac++;
   XtSetArg(al[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
   XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
   XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
   XtSetArg(al[ac], XmNorientation, XmHORIZONTAL); ac++;
   buttonDrawingSeparator = XmCreateSeparator(form, "buttonDrawingSeparator", al, ac);
   XtManageChild(buttonDrawingSeparator);

   /* create stack drawing area widget */
   ac = 0;
   XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
   XtSetArg(al[ac], XmNtopWidget, buttonDrawingSeparator); ac++;
   XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
   XtSetArg(al[ac], XmNwidth, WIDTHOFSTACKDRAWINGAREA); ac++;
   XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
   XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
   gStackDrawingArea = XmCreateDrawingArea(form, "gStackDrawingArea", al, ac);
   XtManageChild(gStackDrawingArea);
   XtAddCallback(gStackDrawingArea, XmNexposeCallback, (XtCallbackProc)ExposeCB, (XtPointer)STACK);
   XtAddCallback(gStackDrawingArea, XmNresizeCallback, (XtCallbackProc)ResizeCB, (XtPointer)STACK);

   /* create stack scroll bar */
   ac = 0;
   XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
   XtSetArg(al[ac], XmNtopWidget, buttonDrawingSeparator); ac++;
   XtSetArg(al[ac], XmNrightAttachment, XmATTACH_NONE); ac++;
   XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
   XtSetArg(al[ac], XmNleftWidget, gStackDrawingArea); ac++;
   XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
   XtSetArg(al[ac], XmNwidth, SCROLLBARWIDTH); ac++;
   XtSetArg(al[ac], XmNorientation, XmVERTICAL); ac++;
   XtSetArg(al[ac], XmNprocessingDirection, XmMAX_ON_TOP); ac++;
   XtSetArg(al[ac], XmNmaximum, STACKMAXY); ac++;
   XtSetArg(al[ac], XmNminimum, STACKMINY); ac++;
   gStackScroll = XmCreateScrollBar(form, "gStackScroll", al, ac);
   XtManageChild(gStackScroll);
   XtAddCallback(gStackScroll, XmNvalueChangedCallback, (XtCallbackProc)ScrollCB, (XtPointer)STACKVERTICAL);

   /* create a separator between the tree scroll bars */
   ac = 0;
   XtSetArg(al[ac], XmNtopAttachment, XmATTACH_NONE); ac++;
   XtSetArg(al[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
   XtSetArg(al[ac], XmNleftAttachment, XmATTACH_NONE); ac++;
   XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
   XtSetArg(al[ac], XmNwidth, SCROLLBARWIDTH); ac++;
   XtSetArg(al[ac], XmNheight, SCROLLBARWIDTH); ac++;
   XtSetArg(al[ac], XmNseparatorType, XmNO_LINE); ac++;
   scrollScrollSeparator = XmCreateSeparator(form, "scrollScrollSeparator", al, ac);
   XtManageChild(scrollScrollSeparator);

   /* create tree scroll bars */
   ac = 0;
   XtSetArg(al[ac], XmNtopAttachment, XmATTACH_NONE); ac++;
   XtSetArg(al[ac], XmNrightAttachment, XmATTACH_WIDGET); ac++;
   XtSetArg(al[ac], XmNrightWidget, scrollScrollSeparator); ac++;
   XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
   XtSetArg(al[ac], XmNleftWidget, gStackScroll); ac++;
   XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
   XtSetArg(al[ac], XmNwidth, SCROLLBARWIDTH); ac++;
   XtSetArg(al[ac], XmNorientation, XmHORIZONTAL); ac++;
   XtSetArg(al[ac], XmNprocessingDirection, XmMAX_ON_RIGHT); ac++;
   XtSetArg(al[ac], XmNmaximum, TREEMAXX); ac++;
   XtSetArg(al[ac], XmNminimum, TREEMINX); ac++;
   gTreeHorizontalScroll = XmCreateScrollBar(form, "gTreeHorizontalScroll", al, ac);
   XtManageChild(gTreeHorizontalScroll);
   XtAddCallback(gTreeHorizontalScroll, XmNvalueChangedCallback, (XtCallbackProc)ScrollCB, (XtPointer)TREEHORIZONTAL);

   ac = 0;
   XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
   XtSetArg(al[ac], XmNtopWidget, buttonDrawingSeparator); ac++;
   XtSetArg(al[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
   XtSetArg(al[ac], XmNleftAttachment, XmATTACH_NONE); ac++;
   XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_WIDGET); ac++;
   XtSetArg(al[ac], XmNbottomWidget, scrollScrollSeparator); ac++;
   XtSetArg(al[ac], XmNwidth, SCROLLBARWIDTH); ac++;
   XtSetArg(al[ac], XmNorientation, XmVERTICAL); ac++;
   XtSetArg(al[ac], XmNprocessingDirection, XmMAX_ON_TOP); ac++;
   XtSetArg(al[ac], XmNmaximum, TREEMAXY); ac++;
   XtSetArg(al[ac], XmNminimum, TREEMINY); ac++;
   gTreeVerticalScroll = XmCreateScrollBar(form, "gTreeVerticalScroll", al, ac);
   XtManageChild(gTreeVerticalScroll);
   XtAddCallback(gTreeVerticalScroll, XmNvalueChangedCallback, (XtCallbackProc)ScrollCB, (XtPointer)TREEVERTICAL);

   /* create tree drawing area widget */
   ac = 0;
   XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
   XtSetArg(al[ac], XmNtopWidget, buttonDrawingSeparator); ac++;
   XtSetArg(al[ac], XmNrightAttachment, XmATTACH_WIDGET); ac++;
   XtSetArg(al[ac], XmNrightWidget, gTreeVerticalScroll); ac++;
   XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
   XtSetArg(al[ac], XmNleftWidget, gStackScroll); ac++;
   XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_WIDGET); ac++;
   XtSetArg(al[ac], XmNbottomWidget, gTreeHorizontalScroll); ac++;
   gTreeDrawingArea = XmCreateDrawingArea(form, "gTreeDrawingArea", al, ac);
   XtManageChild(gTreeDrawingArea);
   XtAddCallback(gTreeDrawingArea, XmNexposeCallback, (XtCallbackProc)ExposeCB, (XtPointer)TREE);
   XtAddCallback(gTreeDrawingArea, XmNresizeCallback, (XtCallbackProc)ResizeCB, (XtPointer)TREE);

   /* create the dialog box. */
   ac = 0;
   XtSetArg(al[ac], XmNselectionLabelString, XmStringCreateLtoR("How many steps? ", gCharSet)); ac++;
   gDialog = XmCreatePromptDialog(topLevel, "gDialog", al, ac);
   XtAddCallback(gDialog, XmNokCallback, (XtCallbackProc)DialogCB, (XtPointer)OK);
   XtAddCallback(gDialog, XmNcancelCallback, (XtCallbackProc)DialogCB, (XtPointer)CANCEL);
   XtUnmanageChild(XmSelectionBoxGetChild(gDialog, XmDIALOG_HELP_BUTTON));

   SetupGc();

   XtRealizeWidget(topLevel);
   XtAppMainLoop(context);
   }

void CreateNonLeafParseTree(ParseTreeHdl * tree, char *nodeName, int nameLength)
   {
   assert(*tree == NULL);
 
   /* give the tree a default (x,y) position, it will change when HandleReduciton sets its children */
   CreateParseTree(&*tree, gNumValues, nodeName, nameLength, 0, 0);
   }

void CreateLeafParseTree(ParseTreeHdl * tree, char *leafName, int nameLength)
   {
   int x,
       y;

   assert(*tree == NULL);

   /* calucluate tree's (x,y) position*/
   x = LEFTOFTREE + (gLeafNumber * NODEWIDTH);
   y = BOTTOMOFTREE;

   CreateParseTree(&*tree, gNumValues, leafName, nameLength, x, y);
   gLeafNumber++;
   }

void HandleReduction(ParseTreeListHdl *list)
   {
   ParseTreeHdl root,
                cur;

   assert(*list != NULL);
   assert(!IsEmpty(*list));

   /* get the root out of list*/
   MoveFirst(*list);
   root = FlaggedParseTreeHdl(*list);
   DeleteFirst(*list);
   /* now list only contains root's children*/
 
   /* if the list isn't empty there are children to deal with*/
   if (!IsEmpty(*list))
      {
      /* then setup for the following while loop*/
      MoveFirst(*list);
      while(ExistsFlagged(*list)) /*for each child*/
         {
         /* get the child from the list*/
         cur = FlaggedParseTreeHdl(*list);
         /* make it a child of root*/
         SetNewRightChild(root, cur, NODEHEIGHT, BOTTOMOFTREE);
         /* pop a child off the "stack" because they are all going to be replaced by root*/
         DeleteLast(gParseTreeList);
         /* setup for next time through loop*/
         MoveNext(*list);
         }
      }

   /* push the root on the "stack"*/
   AddLast(gParseTreeList, root);
 
   /* update the screen */
   DrawAll();
 
   /* clean up*/
   DestroyParseTreeList(&*list);
   }

void HandleToken(ParseTreeHdl tokenTree)
   {
   /* push the token on the "stack"*/
   AddLast(gParseTreeList, tokenTree);
   /* update the screen*/
   DrawAll();
   }

void SetupGc(void)
/* set up the graphics context. */
   {
   int foreground,
       background;
   XGCValues vals;
   Arg al[10];
   int ac;
 
   /* get the current fg and bg colors. */
   ac = 0;
   XtSetArg(al[ac], XmNforeground, &foreground); ac++;
   XtSetArg(al[ac], XmNbackground, &background); ac++;
   XtGetValues(gTreeDrawingArea, al, ac);
 
   /* create the gGC. */
   vals.foreground = foreground;
   vals.background = background;
   gGC = XtGetGC(gTreeDrawingArea, GCForeground | GCBackground, &vals);
   }

void ButtonCB(Widget theWidget, int clientData, XtPointer callData)
/* gets called when a push button gets clicked */
   {
   switch(clientData)
      {
      case START:
         gStepParse_flag = REDUCTIONS;
         CreateParseTreeList(&gParseTreeList);
         DrawStack();
         XtSetSensitive(gStartButton, FALSE);
         XtSetSensitive(gStepButton, TRUE);
         XtSetSensitive(gMultiStepButton, TRUE);
         XtSetSensitive(gGoButton, TRUE);
         break;
      case STEP:
         if (yyparse() != 2)
            {
            XtSetSensitive(gStepButton, FALSE);
            XtSetSensitive(gMultiStepButton, FALSE);
            XtSetSensitive(gGoButton, FALSE);
            }
         break;
      case MULTISTEP:
         XtManageChild(gDialog);
         break;
      case GO:
         gStepParse_flag = NORMAL;
         yyparse();
         XtSetSensitive(gStepButton, FALSE);
         XtSetSensitive(gMultiStepButton, FALSE);
         XtSetSensitive(gGoButton, FALSE);
         break;
      case QUIT:
         exit(0);
         break;
      default:
         exit(1);
         break;
      }
   }

void DialogCB(Widget theWidget, int clientData, XmSelectionBoxCallbackStruct *callData)
/* gets called when a button in the dialog initiated by clicking the MultiStep button gets clicked */
   {
   char *s;
   int i,
       steps;
   int flag = 1;
 
   switch(clientData)
      {
      case OK:
         /* get the string from the event structure. */
         XmStringGetLtoR(callData->value, gCharSet, &s);
         steps = atoi(s);
         for (i = 1; (i <= steps) && flag; i++)
            {
            if (yyparse() != 2)
               {
               flag = 0;
               XtSetSensitive(gStepButton, FALSE);
               XtSetSensitive(gMultiStepButton, FALSE);
               XtSetSensitive(gGoButton, FALSE);
               }
            }
         XtFree(s);
         break;
      case CANCEL:
         break;
      }
   /* make the dialog box invisible */
   XtUnmanageChild(theWidget);
   }
 
void ExposeCB(Widget theWidget, int clientData, XtPointer callData)
/* gets called when some part of one of the drawing areas gets exposed */
   {
   switch(clientData)
      {
      case TREE:
         {
         XClearArea(XtDisplay(gTreeDrawingArea), XtWindow(gTreeDrawingArea), 0, 0, 0, 0, FALSE);
         DrawTrees();
         break;
         }
      case STACK:
         {
         DrawStack();
         break;
         }
      default:
         {
         break;
         }
      }
   }

void ResizeCB(Widget theWidget, int clientData, XtPointer callData)
/* gets called when one of the drawing areas gets resized */
   {
   Dimension height,
             width;
   Arg al[10];
   int ac;
 
   switch(clientData)
      {
      case TREE:
         {
         /* get new drawing area size */
         ac = 0;
         XtSetArg(al[ac], XmNheight, &(height)); ac++;
         XtSetArg(al[ac], XmNwidth, &(width)); ac++;
         XtGetValues(theWidget, al, ac);
         gWindowYOffset = height - ORGHEIGHTOFTREEDRAWINGAREA;
 
         /* adjust scroll bars */
         ac = 0;
         XtSetArg(al[ac], XmNpageIncrement, width/2); ac++;
         XtSetValues(gTreeHorizontalScroll, al ,ac);
 
         ac = 0;
         XtSetArg(al[ac], XmNpageIncrement, height/2); ac++;
         XtSetValues(gTreeVerticalScroll, al ,ac);
 
         if(XtIsRealized(theWidget))
            {
            XClearArea(XtDisplay(gTreeDrawingArea), XtWindow(gTreeDrawingArea), 0, 0, 0, 0, FALSE);
            DrawTrees();
            }
         break;
         }
      case STACK:
         {
         /* get new drawing area size */
         ac = 0;
         XtSetArg(al[ac], XmNheight, &(height)); ac++;
         XtGetValues(theWidget, al, ac);
         gWindowYOffset = height - ORGHEIGHTOFSTACKDRAWINGAREA;
 
         /* adjust scroll bar */
         ac = 0;
         XtSetArg(al[ac], XmNpageIncrement, height/2); ac++;
         XtSetValues(gStackScroll, al ,ac);
 
         if(XtIsRealized(theWidget))
            {
            DrawStack();
            }
         break;
         }
      default:
         {
         break;
         }
      }
   }

void ScrollCB(Widget theWidget, int clientData, XtPointer callData)
/* gets called when one of the scroll bars gets slid */
   {
   Arg al[10];
   int ac;
   int value;
 
   switch(clientData)
      {
      case TREEHORIZONTAL:
         {
         /* will generate a subsequent expose event */
         XClearArea(XtDisplay(gTreeDrawingArea), XtWindow(gTreeDrawingArea), 0, 0, 0, 0, TRUE);
 
         /* get new scroll bar value and adjust gTreeDrawingXOffset */
         ac = 0;
         XtSetArg(al[ac], XmNvalue, &value); ac++;
         XtGetValues(theWidget, al, ac);
         gTreeDrawingXOffset = value;
         break;
         }
      case TREEVERTICAL:
         {
         /* will generate a subsequent expose event */
         XClearArea(XtDisplay(gTreeDrawingArea), XtWindow(gTreeDrawingArea), 0, 0, 0, 0, TRUE);
 
         /* get new scroll bar value and adjust gTreeDrawingYOffset */
         ac = 0;
         XtSetArg(al[ac], XmNvalue, &value); ac++;
         XtGetValues(theWidget, al, ac);
         gTreeDrawingYOffset = value;
         break;
         }
      case STACKVERTICAL:
         {
         /* will generate a subsequent expose event */
         XClearArea(XtDisplay(gStackDrawingArea), XtWindow(gStackDrawingArea), 0, 0, 0, 0, TRUE);
 
         /* get new scroll bar value and adjust gStackDrawingYOffset */
         ac = 0;
         XtSetArg(al[ac], XmNvalue, &value); ac++;
         XtGetValues(theWidget, al, ac);
         gStackDrawingYOffset = value;
         break;
         }
      default:
         {
         break;
         }
      }
   }

void DrawAll(void)
   {
   DrawTrees();
   DrawStack();
   }

void DrawStack(void)
   {
   ParseTreeHdl tree;
   char *s;
   int sLength;
   int count = 0;
   int x1 = LEFTOFSTACK,
       y1,
       x2 = RIGHTOFSTACK,
       y2;
   int stackElementHeight = ORGSTACKELEMENTHEIGHT + (VALUEELEMENTHEIGHT * gNumValues);
   int i;
   int orgValue;
   int valueLength;
   char *valueString = (char *)calloc(30, sizeof(char));
 
   XClearArea(XtDisplay(gStackDrawingArea), XtWindow(gStackDrawingArea), 0, 0, 0, 0, FALSE);
   if (gParseTreeList != NULL)
      {
      if (!IsEmpty(gParseTreeList))
         {
         MoveFirst(gParseTreeList);
         while(ExistsFlagged(gParseTreeList)) /* for each element in the "stack"*/
            {
            /* draw a slot to put the element in */
            y1 = BOTTOMOFSTACK - (stackElementHeight * (count + 1));
            y2 = BOTTOMOFSTACK - (stackElementHeight * count);
            XDrawLine(XtDisplay(gStackDrawingArea), XtWindow(gStackDrawingArea), gGC, x1, y1 + gWindowYOffset + gStackDrawingYOffset,
                      x1, y2 + gWindowYOffset + gStackDrawingYOffset);
            XDrawLine(XtDisplay(gStackDrawingArea), XtWindow(gStackDrawingArea), gGC, x1, y2 + gWindowYOffset + gStackDrawingYOffset,
                      x2, y2 + gWindowYOffset + gStackDrawingYOffset);
            XDrawLine(XtDisplay(gStackDrawingArea), XtWindow(gStackDrawingArea), gGC, x2, y2 + gWindowYOffset + gStackDrawingYOffset,
                      x2, y1 + gWindowYOffset + gStackDrawingYOffset);

            /* draw the element in the slot*/
            tree = FlaggedParseTreeHdl(gParseTreeList);
            /* by getting and drawing it's name*/
            GetParseTreeString(tree, &s, &sLength);
            XDrawString(XtDisplay(gStackDrawingArea), XtWindow(gStackDrawingArea), gGC, x1 + STACKSTRINGXOFFSET,
                        (y1 + ORGSTACKELEMENTHEIGHT - STACKSTRINGYOFFSET) + gWindowYOffset + gStackDrawingYOffset,
                        s, sLength);
            /* and by getting and drawing each of it's values*/
            for (i = 0; i < gNumValues; i++) /* for each value */
               {
               orgValue = GetParseTreeOrgValue(tree, i);
               valueLength = sprintf(valueString, "%d", orgValue);
               XDrawString(XtDisplay(gStackDrawingArea), XtWindow(gStackDrawingArea), gGC, x1 + STACKSTRINGXOFFSET,
                           y1 + ORGSTACKELEMENTHEIGHT - STACKSTRINGYOFFSET + (VALUEELEMENTHEIGHT * (i + 1)) + gWindowYOffset + gStackDrawingYOffset,
                           valueString, valueLength);
               }

            /* set up for next time through loop*/
            MoveNext(gParseTreeList);
            count++;
            }
         }

      /* draw a slot for one more element at the top so that we can tell that it's the top an not the bottom */
      y1 = BOTTOMOFSTACK - (stackElementHeight * (count + 1));
      y2 = BOTTOMOFSTACK - (stackElementHeight * count);
      XDrawLine(XtDisplay(gStackDrawingArea), XtWindow(gStackDrawingArea), gGC, x1, y1 + gWindowYOffset + gStackDrawingYOffset,
                x1, y2 + gWindowYOffset + gStackDrawingYOffset);
      XDrawLine(XtDisplay(gStackDrawingArea), XtWindow(gStackDrawingArea), gGC, x1, y2 + gWindowYOffset + gStackDrawingYOffset,
                x2, y2 + gWindowYOffset + gStackDrawingYOffset);
      XDrawLine(XtDisplay(gStackDrawingArea), XtWindow(gStackDrawingArea), gGC, x2, y2 + gWindowYOffset + gStackDrawingYOffset,
                x2, y1 + gWindowYOffset + gStackDrawingYOffset);
      }
   XFlush(XtDisplay(gStackDrawingArea));
   }

void DrawTrees(void)
   {
   ParseTreeHdl tree;
 
   if (gParseTreeList != NULL)
      {
      if (!IsEmpty(gParseTreeList))
         {
         MoveFirst(gParseTreeList);
         while(ExistsFlagged(gParseTreeList)) /* for each parseTree on the "stack"*/
            {
            tree = FlaggedParseTreeHdl(gParseTreeList);
            DrawParseTree(tree);
            MoveNext(gParseTreeList);
            }
         }
      }
   XFlush(XtDisplay(gTreeDrawingArea));
   }

void DrawParseTree(ParseTreeHdl tree)
   {
   ParseTreeHdl child = GetLeftChild(tree);
   int x, y;
   char *s;
   int sLength;
 
   /* draw the tree's root node */
   GetParseTreePosition(tree, &x, &y);
   GetParseTreeString(tree, &s, &sLength);
   XDrawString(XtDisplay(gTreeDrawingArea), XtWindow(gTreeDrawingArea), gGC, x - gTreeDrawingXOffset,
               y + gWindowYOffset + gTreeDrawingYOffset,
               s, sLength);
   while(child != NULL) /* for each of tree's children */
      {
      /* draw the tree rooted at the child*/
      DrawParseTree(child);
      /* draw the line conecting root to child */
      ConnectNodes(tree, child);

      /* set up for next time throught loop*/
      child = GetRightSib(child);
      }
   }

void ConnectNodes(ParseTreeHdl highNode, ParseTreeHdl lowNode)
   {
   int hx,
       hy,
       lx,
       ly;
 
   GetParseTreePosition(highNode, &hx, &hy);
   GetParseTreePosition(lowNode, &lx, &ly);
   hy = hy +3;
   ly = ly -10;
 
   XDrawLine(XtDisplay(gTreeDrawingArea), XtWindow(gTreeDrawingArea), gGC, hx - gTreeDrawingXOffset, hy + gWindowYOffset + gTreeDrawingYOffset,
             lx - gTreeDrawingXOffset, hy + gWindowYOffset + gTreeDrawingYOffset);
   XDrawLine(XtDisplay(gTreeDrawingArea), XtWindow(gTreeDrawingArea), gGC, lx - gTreeDrawingXOffset, hy + gWindowYOffset + gTreeDrawingYOffset,
             lx - gTreeDrawingXOffset, ly + gWindowYOffset + gTreeDrawingYOffset);
   }
