
# line 2 "./ny.temp.y"

typedef enum {ny_empty,ny_terminal,ny_nonTerminal} ny_TokenType;


/***********************************************************************
 
 What This Is:      Newyacc specification for building a source-to-
			source translator which takes a yacc
			specification and produces a second yacc
			specification which has all the same behavior
			as the original plus the added behavior of
			drawing the parse tree and stack to the screen
			specifications
 Author:            Modified by Laura Deddens from start code provided
                    by Dr. Elizabeth White.
 Email:             lelo@cats.ucsc.edu (Laura)
 Last Modified:     5 September 1996
 
***********************************************************************/
#include <stdio.h>
#include <string.h>
#include "nytags.h"

typedef struct TokenNodeStruct *TokenNodeHdl;
typedef struct TokenNodeStruct {
   char *tokenName;
   char *newNonTerminalName;
   int typed;
   TokenNodeHdl next;
   int precedence;
   char *newPseudoTokenName;
   int thisPrecedence;
}TokenNodeStruct;

typedef struct NonTerminalNodeStruct *NonTerminalNodeHdl;
typedef struct NonTerminalNodeStruct {
   char *nonTerminalName;
   int typed;
   NonTerminalNodeHdl next;
}NonTerminalNodeStruct;

int gTokenCount = 0;
TokenNodeHdl gTokenList = NULL;
NonTerminalNodeHdl gNonTerminalList = NULL;
int gNumValues;
char *gNonTerminalName;
int gCountRHSElements;
int gCurlyCount;
int gTokenTyped;
int gNonTerminalTyped;
char *gStructName;
TokenNodeHdl gCurPrec;

char *AddTokenSymbol();
char *AddNonTerminalSymbol();
char *PrintIncludes();
char *SetNumValues();
char *PrintTypeNewNonTerminals();
char *InitNonTerminalName();
char *InitRHSElementsCount();
char *IncrRHSElementsCount();
char *LookupTokenSymbol();
char *PrintNonAction();
char *PrintEndAction();
char *PrintNewProductions();
char *PrintSecondDivider();
char *InitCurlyCount();
char *IncrCurlyCount();
char *DecrCurlyCount();
char *PrintCurlyIndent();
char *SetStructName();
char *InitTokenTypedToTrue();
char *InitTokenTypedToFalse();
char *InitNonTerminalTypedToTrue();
char *InitNonTerminalTypedToFalse();
char *PrintType();
char *PrintTypeUntypedTokens();
char *PrintTypeUntypedNonTerminals();
char *PrintNewPseudoTokens();
char *MarkWithThisPrec();
char *MarkWithPrec();
char *InitCurPrec();
char *PrintNonPrecedence();
char *myprint(char *s);
# define TOKEN_T 257
# define LEFT_T 258
# define RIGHT_T 259
# define TYPE_T 260
# define NONASSOC_T 261
# define PREC_T 262
# define NAME 263
# define CHAR 264
# define DIVIDER 265
# define ENDDIVIDER 266
# define ENDCHAR 267
# define LCURL 268
# define CCHAR 269
# define RCURL 270
# define UNION_T 271
# define STRUCT_U 272
# define INT_U 273
# define INT 274
# define NAME_U 275
# define UCHAR 276
# define ALCURLY 277
# define ASPACE 278
# define ARETURN 279
# define ACHAR 280
# define ARCURLY 281
# define SQUOAT 282
# define SCHAR 283
# define BEGINLIT 284
# define LQUOAT 285
# define LCHAR 286
# define ENDLIT 287
# define JUNK 288

#ifdef __STDC__
#include <stdlib.h>
#include <string.h>
#else
#include <malloc.h>
#include <memory.h>
#endif

#include <values.h>

#ifdef __cplusplus

#ifndef yyerror
	void yyerror(const char *);
#endif

#ifndef yylex
#ifdef __EXTERN_C__
	extern "C" { int yylex(void); }
#else
	int yylex(void);
#endif
#endif
	int yyparse(void);

#endif
#define yyclearin yychar = -1
#define yyerrok yyerrflag = 0
extern int yychar;
extern int yylineno; extern int yyerrflag;
#ifndef YYSTYPE
#define YYSTYPE int
#endif
YYSTYPE yylval;
YYSTYPE yyval;
typedef int yytabelem;
#ifndef YYMAXDEPTH
#define YYMAXDEPTH 150
#endif
#if YYMAXDEPTH > 0
int yy_yys[YYMAXDEPTH], *yys = yy_yys;
YYSTYPE yy_yyv[YYMAXDEPTH], *yyv = yy_yyv;
#else	/* user does initial allocation */
int *yys;
YYSTYPE *yyv;
#endif
static int yymaxdepth = YYMAXDEPTH;
# define YYERRCODE 256

# line 327 "./ny.temp.y"


char *AddTokenSymbol(argc, argv)
     int argc;
     char **argv;
   {
   TokenNodeHdl cur = gTokenList;
   int found = 0;
   char *newNonTerminalName;
   char *num;
   TokenNodeHdl node;
   char *newPseudoTokenName;
 
   while((cur != NULL) && (!found))
      {
      if(strcmp(cur->tokenName, argv[0]) == 0)
         {
         if (cur->typed == 0)
            {
            cur->typed = gTokenTyped;
            }
         found = 1;
         }
      cur = cur->next;
      }
   if (!found)
      {
      num = (char *)calloc(30, sizeof(char));
      node = (TokenNodeHdl)malloc(sizeof(TokenNodeStruct));
      gTokenCount++;
      node->next = gTokenList;
      gTokenList = node;
      node->tokenName = strdup(argv[0]);
      newNonTerminalName = strdup("token");
      sprintf(num, "%d", gTokenCount);
      strcat(newNonTerminalName, num);
      node->newNonTerminalName = newNonTerminalName;
      node->typed = gTokenTyped;
      newPseudoTokenName = strdup("TOKEN");
      strcat(newPseudoTokenName, num);
      node->newPseudoTokenName = newPseudoTokenName;
      node->precedence = 0;
      node->thisPrecedence = 0;
      }
   return NULL;
   }

char *AddNonTerminalSymbol(argc, argv)
      int argc;
      char **argv;
   {
   NonTerminalNodeHdl cur = gNonTerminalList;
   int found = 0;
   NonTerminalNodeHdl node;
 
   while((cur != NULL) && (!found))
      {
      if(strcmp(cur->nonTerminalName, argv[0]) == 0)
         {
         found = 1;
         }
      cur = cur->next;
      }
   if (!found)
      {
      node = (NonTerminalNodeHdl)malloc(sizeof(NonTerminalNodeStruct));
      node->next = gNonTerminalList;
      gNonTerminalList = node;
      node->nonTerminalName = strdup(argv[0]);
      node->typed = gNonTerminalTyped;
      }
   return NULL;
   }

char *PrintIncludes()
   {
   printf("\n#include <parseTree.h>\n#include <parseTreeList.h>\n#include <stepPar.h>\n#include <graphicParse.h>\n");
   return NULL;
   }

char *SetNumValues(argc, argv)
      int argc;
      char **argv;
   {
   gNumValues = atoi(argv[0]);
   return NULL;
   }

char *PrintTypeNewNonTerminals()
   {
   int i;
 
   if (gTokenCount > 0)
      {
      printf("\n%%type <%s>", gStructName);
      for (i = 1; i<=gTokenCount; i++)
         {
         printf(" token%d", i);
         }
      }
   return NULL;
   }

char *InitNonTerminalName(argc, argv)
      int argc;
      char **argv;
   {
   gNonTerminalName = strdup(argv[0]);
 
   return NULL;
   }

char *InitRHSElementsCount()
   {
   gCountRHSElements = 0;
   return NULL;
   }

char  *IncrRHSElementsCount()
   {
   gCountRHSElements++;
   return NULL;
   }

char *LookupTokenSymbol(argc, argv)
      int argc;
      char **argv;
   {
   TokenNodeHdl cur = gTokenList;
   int found = 0;
   char *ans = argv[0];
 
   while((cur != NULL) && (!found))
      {
      if (strcmp(cur->tokenName, argv[0]) == 0)
         {
         found = 1;
         ans = cur->newNonTerminalName;
         if(cur->precedence)
            {
            gCurPrec = cur;
            }
         }
      cur = cur->next;
      }
   return ans;
   }

char *PrintNonAction()
   {
   printf("{\n\t\t\t");
   PrintEndAction();
   printf("\n\t\t\t}");
 
   return NULL;
   }

char *PrintEndAction()
   {
   int i;

   printf("   {\n\t\t\t   ParseTreeListHdl list = NULL;\n");
   if (gCountRHSElements > 0)
      {
      printf("\n\t\t\t   $$.tree = NULL;\n\t\t\t   CreateNonLeafParseTree((ParseTreeHdl *)&($$.tree), \"%s\", strlen(\"%s\"));", gNonTerminalName, gNonTerminalName);
      }
   else
      {
      printf("\n\t\t\t   $$.tree = NULL;\n\t\t\t   CreateLeafParseTree((ParseTreeHdl *)&($$.tree), \"%s\", strlen(\"%s\"));", gNonTerminalName, gNonTerminalName);
      }
   for (i = 0; i < gNumValues; i++)
      {
      printf("\n\t\t\t   SetParseTreeOrgValue($$.tree, $$.x[%d], %d);", i, i);
      }
   printf("\n\t\t\t   CreateParseTreeList(&list);\n\t\t\t   AddFirst(list, $$.tree);");
   for (i = 1; i <= gCountRHSElements; i++)
      {
      printf("\n\t\t\t   AddLast(list, $%d.tree);", i);
      }
   printf("\n\t\t\t   HandleReduction(&list);\n\t\t\t   }");

   return NULL;
   }

char *PrintNewProductions()
   {
   int i;
   TokenNodeHdl cur = gTokenList;
 
   printf("\n");
   while (cur != NULL)
      {
      printf("%s\t:\t%s\n\t\t\t{\n\t\t\t$$.tree = NULL;\n\t\t\tCreateLeafParseTree((ParseTreeHdl *)&($$.tree), \"%s\", strlen(\"%s\"));\n\t\t\t", cur->newNonTerminalName, cur->tokenName, cur->tokenName, cur->tokenName );
      for (i = 0; i < gNumValues; i++)
         {
         printf("SetParseTreeOrgValue($$.tree, $1.x[%d], %d);\n\t\t\t", i, i);
         }
      printf("HandleToken($$.tree);\n\t\t\t}\n\t\t;\n\n");
      cur = cur->next;
      }
   return NULL;
   }
 
char *PrintSecondDivider()
   {
   printf("%%%%\n\nint main(int argc, char *argv[])\n   {\n   gNumValues = %d;\n   MyMain(argc, argv);\n   return 0;\n   }\n\n\n\n", gNumValues);
   return NULL;
   }

char *InitCurlyCount()
   {
   gCurlyCount = 0;
   return NULL;
   }

char *IncrCurlyCount()
   {
   gCurlyCount++;
   return NULL;
   }

char *DecrCurlyCount()
   {
   gCurlyCount--;
   return NULL;
   }

char *PrintCurlyIndent()
   {
   int i;

   for (i = 1; i <= gCurlyCount; i++)
      {
      printf("   ");
      }

   return NULL;
   }

char *SetStructName(argc, argv)
      int argc;
      char **argv;
   {
   gStructName = strdup(argv[0]);
   return NULL;
   }

char *InitTokenTypedToTrue()
   {
   gTokenTyped = 1;
   return NULL;
   }

char *InitTokenTypedToFalse()
   {
   gTokenTyped = 0;
   return NULL;
   }

char *InitNonTerminalTypedToTrue()
   {
   gNonTerminalTyped = 1;
   return NULL;
   }
 
char *InitNonTerminalTypedToFalse()
   {
   gNonTerminalTyped = 0;
   return NULL;
   }

char *PrintType()
   {
   printf("<%s>", gStructName);
   return NULL;
   }

char *PrintTypeUntypedTokens()
   {
   int i;
   TokenNodeHdl cur = gTokenList;
   int started = 0;
 
   while (cur != NULL)
      {
      if (cur->typed == 0)
         {
         if (started == 0)
            {
            printf("%%token ");
            PrintType();
            started = 1;
            }
         printf(" %s", cur->tokenName);
         }
      cur = cur->next;
      }
   if (started = 1)
      {
      printf("\n");
      }
   return NULL;
   }

char *PrintTypeUntypedNonTerminals()
   {
   int i;
   NonTerminalNodeHdl cur = gNonTerminalList;
   int started = 0;

   while (cur != NULL)
      {
      if (cur->typed == 0)
         {
         if (started == 0)
            {
            printf("\n%%type ");
            PrintType();
            started = 1;
            }
         printf(" %s", cur->nonTerminalName);
         }
      cur = cur->next;
      }
   return NULL;
   }

char *PrintNewPseudoTokens()
   {
   TokenNodeHdl cur = gTokenList;

   while(cur != NULL)
      {
      if (cur->thisPrecedence)
         {
         printf(" %s", cur->newPseudoTokenName);
         cur->thisPrecedence = 0;
         }
      cur = cur->next;
      }

   return NULL;
   }

char *MarkWithThisPrec(argc, argv)
     int argc;
     char **argv;
   {
   TokenNodeHdl cur = gTokenList;
   int found = 0;
   
   while((cur != NULL) && (!found)) 
      {
      if(strcmp(cur->tokenName, argv[0]) == 0)
         {
         found = 1;
         cur->thisPrecedence = 1;
         }
      cur = cur->next;
      }
 
   return NULL;
   }
 
char *MarkWithPrec(argc, argv)
     int argc;
     char **argv;
   {
   TokenNodeHdl cur = gTokenList;
   int found = 0;

   while((cur != NULL) && (!found))
      {
      if(strcmp(cur->tokenName, argv[0]) == 0)
         {
         found = 1;
         cur->precedence = 1;
         }
      cur = cur->next;
      }

   return NULL;
   }

char *InitCurPrec()
   {
   gCurPrec = NULL;

   return NULL;
   }

char *PrintNonPrecedence()
   {
   if (gCurPrec != NULL)
      {
      printf(" %%prec %s", gCurPrec->newPseudoTokenName);
      }

   return NULL;
   }

char *myprint(s)
char *s;
{
  if(s != 0) fputs(s,stdout);
  return NULL;
}

yyerror()
{
  fprintf(stderr, "syntax error on line %d\n",yylineno);
  fflush(stderr);
  exit(1);
}

main()
{
  if (yyparse() != 0) {fprintf(stderr,"exiting"); exit(1); }
  nyprint(myprint,P,NY_OPEN,NY_NORMAL);
}
static const yytabelem yyexca[] ={
-1, 1,
	0, -1,
	-2, 0,
	};
# define YYNPROD 65
# define YYLAST 254
static const yytabelem yyact[]={

    81,    91,    92,    90,    87,    96,    13,    16,    15,    14,
    17,    98,    86,    64,    38,    22,    21,     7,     5,    61,
    12,    54,    20,    41,    42,    36,    30,    31,    13,    16,
    15,    14,    17,    72,   100,    69,    66,    44,    43,    20,
    55,    61,    50,    24,    71,    93,    83,    53,    52,    27,
    26,    99,    94,    37,    58,    40,    48,    19,     6,    29,
    28,     4,    46,    85,    84,     8,    80,    79,    70,    23,
    59,    57,    49,    47,    65,    39,    35,    32,    33,    25,
    11,    95,    10,     9,     3,    34,    18,     2,    45,     1,
     0,    73,    45,    45,     0,    51,     0,     0,     0,     0,
     0,     0,     0,     0,     0,    56,     0,     0,     0,     0,
     0,     0,    68,    67,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,    97,     0,    60,    62,
    63,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,    77,    76,    75,    74,    78,     0,     0,
    82,     0,    88,    89 };
static const yytabelem yypact[]={

  -250,-10000000,  -248,-10000000,-10000000,-10000000,  -251,  -224,-10000000,  -254,
-10000000,-10000000,   -80,   -10,   -11,  -237,  -237,  -237,  -241,-10000000,
    -5,-10000000,-10000000,  -229,  -258,  -240,  -225,  -226,  -237,-10000000,
-10000000,-10000000,  -237,  -237,-10000000,-10000000,-10000000,-10000000,   -81,  -240,
-10000000,-10000000,-10000000,   -14,   -15,-10000000,  -246,   -19,-10000000,  -104,
  -260,-10000000,-10000000,  -227,-10000000,-10000000,-10000000,   -82,-10000000,-10000000,
  -228,-10000000,-10000000,-10000000,   -76,  -230,-10000000,-10000000,-10000000,-10000000,
   -34,   -45,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,
-10000000,-10000000,-10000000,  -262,   -30,  -284,   -48,-10000000,-10000000,-10000000,
-10000000,-10000000,-10000000,    -7,-10000000,  -120,  -264,-10000000,    -8,   -91,
-10000000 };
static const yytabelem yypgo[]={

     0,    89,    87,    86,    85,    84,    61,    83,    58,    82,
    81,    80,    79,    75,    74,    60,    55,    59,    57,    73,
    56,    72,    71,    54,    70,    68,    67,    66,    64,    63,
    62 };
static const yytabelem yyr1[]={

     0,     1,     2,     2,     5,     7,     7,     6,     9,    10,
    10,     8,     8,    11,    11,    11,    11,    11,    12,    12,
    13,    13,    16,    16,    14,    14,    15,    15,    17,    17,
     3,     3,    18,    19,    19,    20,    20,    20,    20,    21,
    21,    24,    24,    22,    23,    25,    25,    25,    25,    25,
    25,    25,    25,    26,    28,    28,    28,    27,    29,    29,
    29,     4,     4,    30,    30 };
static const yytabelem yyr2[]={

     0,     9,     5,     3,     7,     5,     1,     7,    31,     5,
     1,     5,     1,     7,    11,     5,     5,     5,     1,     7,
     5,     3,     3,     3,     5,     3,     5,     3,     3,     3,
     5,     3,     9,     7,     3,     7,     5,     5,     3,     5,
     1,     3,     3,     5,     7,     5,     5,     5,     5,     5,
     5,     5,     1,     7,     5,     5,     1,     7,     5,     5,
     1,     1,     5,     5,     1 };
static const yytabelem yychk[]={

-10000000,    -1,    -2,    -5,    -6,   268,    -8,   265,    -6,    -7,
    -9,   -11,   271,   257,   260,   259,   258,   261,    -3,   -18,
   263,   270,   269,    -8,   123,   -12,    60,    60,   -15,   -17,
   263,   264,   -15,   -15,    -4,   -18,   266,    58,   272,   -13,
   -16,   263,   264,   263,   263,   -17,   -30,   -19,   -20,   -21,
   123,   -16,    62,    62,   267,    59,   124,   -22,   -23,   -24,
   262,   123,   263,   264,   273,   -14,   263,   -20,   -23,   263,
   -25,   120,   263,   125,   280,   279,   278,   277,   281,   -26,
   -27,    34,   284,    91,   -28,   -29,   274,    34,   282,   283,
   287,   285,   286,    93,    59,   -10,   125,   276,   275,    59,
   125 };
static const yytabelem yydef[]={

    12,    -2,     0,    12,     3,     6,     0,     0,     2,     0,
    12,    11,     0,    18,     0,     0,     0,     0,    61,    31,
     0,     4,     5,     7,     0,     0,     0,     0,    15,    27,
    28,    29,    16,    17,     1,    30,    64,    40,     0,    13,
    21,    22,    23,     0,     0,    26,    62,     0,    34,    38,
     0,    20,    19,     0,    63,    32,    40,    37,    36,    39,
     0,    52,    41,    42,     0,    14,    25,    33,    35,    43,
     0,     0,    24,    44,    45,    46,    47,    48,    49,    50,
    51,    56,    60,     0,     0,     0,     0,    53,    54,    55,
    57,    58,    59,     0,    10,     0,     0,     9,     0,     0,
     8 };
typedef struct
#ifdef __cplusplus
	yytoktype
#endif
{ char *t_name; int t_val; } yytoktype;
#ifndef YYDEBUG
#	define YYDEBUG	0	/* don't allow debugging */
#endif

#if YYDEBUG

yytoktype yytoks[] =
{
	"TOKEN_T",	257,
	"LEFT_T",	258,
	"RIGHT_T",	259,
	"TYPE_T",	260,
	"NONASSOC_T",	261,
	"PREC_T",	262,
	"NAME",	263,
	"CHAR",	264,
	"DIVIDER",	265,
	"ENDDIVIDER",	266,
	"ENDCHAR",	267,
	"LCURL",	268,
	"CCHAR",	269,
	"RCURL",	270,
	"UNION_T",	271,
	"STRUCT_U",	272,
	"INT_U",	273,
	"INT",	274,
	"NAME_U",	275,
	"UCHAR",	276,
	"ALCURLY",	277,
	"ASPACE",	278,
	"ARETURN",	279,
	"ACHAR",	280,
	"ARCURLY",	281,
	"SQUOAT",	282,
	"SCHAR",	283,
	"BEGINLIT",	284,
	"LQUOAT",	285,
	"LCHAR",	286,
	"ENDLIT",	287,
	"JUNK",	288,
	"-unknown-",	-1	/* ends search */
};

char * yyreds[] =
{
	"-no such reduction-",
	"yacc_spec : begining DIVIDER rule_list ending",
	"begining : cCode defn_list_complete",
	"begining : defn_list_complete",
	"cCode : LCURL cList RCURL",
	"cList : cList CCHAR",
	"cList : /* empty */",
	"defn_list_complete : defn_list union_defn defn_list",
	"union_defn : UNION_T '{' STRUCT_U '{' INT_U 'x' '[' INT ']' ';' union_list '}' NAME_U ';' '}'",
	"union_list : union_list UCHAR",
	"union_list : /* empty */",
	"defn_list : defn_list defn",
	"defn_list : /* empty */",
	"defn : TOKEN_T opt_type token_list",
	"defn : TYPE_T '<' NAME '>' type_list",
	"defn : RIGHT_T prec_list",
	"defn : LEFT_T prec_list",
	"defn : NONASSOC_T prec_list",
	"opt_type : /* empty */",
	"opt_type : '<' NAME '>'",
	"token_list : token_list token_elem",
	"token_list : token_elem",
	"token_elem : NAME",
	"token_elem : CHAR",
	"type_list : type_list NAME",
	"type_list : NAME",
	"prec_list : prec_list prec_elem",
	"prec_list : prec_elem",
	"prec_elem : NAME",
	"prec_elem : CHAR",
	"rule_list : rule_list rule",
	"rule_list : rule",
	"rule : NAME ':' rhs_list ';'",
	"rhs_list : rhs_list '|' production",
	"rhs_list : production",
	"production : production_list precedence action",
	"production : production_list action",
	"production : production_list precedence",
	"production : production_list",
	"production_list : production_list production_elem",
	"production_list : /* empty */",
	"production_elem : NAME",
	"production_elem : CHAR",
	"precedence : PREC_T NAME",
	"action : '{' action_list '}'",
	"action_list : action_list ACHAR",
	"action_list : action_list ARETURN",
	"action_list : action_list ASPACE",
	"action_list : action_list ALCURLY",
	"action_list : action_list ARCURLY",
	"action_list : action_list string",
	"action_list : action_list lit",
	"action_list : /* empty */",
	"string : '\"' string_list '\"'",
	"string_list : string_list SQUOAT",
	"string_list : string_list SCHAR",
	"string_list : /* empty */",
	"lit : BEGINLIT lit_list ENDLIT",
	"lit_list : lit_list LQUOAT",
	"lit_list : lit_list LCHAR",
	"lit_list : /* empty */",
	"ending : /* empty */",
	"ending : ENDDIVIDER ending_list",
	"ending_list : ending_list ENDCHAR",
	"ending_list : /* empty */",
};
#endif /* YYDEBUG */
# line	1 "/usr/ccs/bin/yaccpar"
/*
 * Copyright (c) 1993 by Sun Microsystems, Inc.
 */

#pragma ident	"@(#)yaccpar	6.14	97/01/16 SMI"

/*
** Skeleton parser driver for yacc output
*/

/*
** yacc user known macros and defines
*/
#define YYERROR		goto yyerrlab
#define YYACCEPT	return(0)
#define YYABORT		return(1)
#define YYBACKUP( newtoken, newvalue )\
{\
	if ( yychar >= 0 || ( yyr2[ yytmp ] >> 1 ) != 1 )\
	{\
		yyerror( "syntax error - cannot backup" );\
		goto yyerrlab;\
	}\
	yychar = newtoken;\
	yystate = *yyps;\
	yylval = newvalue;\
	goto yynewstate;\
}
#define YYRECOVERING()	(!!yyerrflag)
#define YYNEW(type)	malloc(sizeof(type) * yynewmax)
#define YYCOPY(to, from, type) \
	(type *) memcpy(to, (char *) from, yymaxdepth * sizeof (type))
#define YYENLARGE( from, type) \
	(type *) realloc((char *) from, yynewmax * sizeof(type))
#ifndef YYDEBUG
#	define YYDEBUG	1	/* make debugging available */
#endif

/*
** user known globals
*/
int yydebug;			/* set to 1 to get debugging */

/*
** driver internal defines
*/
#define YYFLAG		(-10000000)

/*
** global variables used by the parser
*/
YYSTYPE *yypv;			/* top of value stack */
int *yyps;			/* top of state stack */

int yystate;			/* current state */
int yytmp;			/* extra var (lasts between blocks) */

int yynerrs;			/* number of errors */
int yyerrflag;			/* error recovery flag */
int yychar;			/* current input token number */



#ifdef YYNMBCHARS
#define YYLEX()		yycvtok(yylex())
/*
** yycvtok - return a token if i is a wchar_t value that exceeds 255.
**	If i<255, i itself is the token.  If i>255 but the neither 
**	of the 30th or 31st bit is on, i is already a token.
*/
#if defined(__STDC__) || defined(__cplusplus)
int yycvtok(int i)
#else
int yycvtok(i) int i;
#endif
{
	int first = 0;
	int last = YYNMBCHARS - 1;
	int mid;
	wchar_t j;

	if(i&0x60000000){/*Must convert to a token. */
		if( yymbchars[last].character < i ){
			return i;/*Giving up*/
		}
		while ((last>=first)&&(first>=0)) {/*Binary search loop*/
			mid = (first+last)/2;
			j = yymbchars[mid].character;
			if( j==i ){/*Found*/ 
				return yymbchars[mid].tvalue;
			}else if( j<i ){
				first = mid + 1;
			}else{
				last = mid -1;
			}
		}
		/*No entry in the table.*/
		return i;/* Giving up.*/
	}else{/* i is already a token. */
		return i;
	}
}
#else/*!YYNMBCHARS*/
#define YYLEX()		yylex()
#endif/*!YYNMBCHARS*/

/*
** yyparse - return 0 if worked, 1 if syntax error not recovered from
*/
#if defined(__STDC__) || defined(__cplusplus)
int yyparse(void)
#else
int yyparse()
#endif
{
	register YYSTYPE *yypvt = 0;	/* top of value stack for $vars */

#if defined(__cplusplus) || defined(lint)
/*
	hacks to please C++ and lint - goto's inside
	switch should never be executed
*/
	static int __yaccpar_lint_hack__ = 0;
	switch (__yaccpar_lint_hack__)
	{
		case 1: goto yyerrlab;
		case 2: goto yynewstate;
	}
#endif

	/*
	** Initialize externals - yyparse may be called more than once
	*/
	yypv = &yyv[-1];
	yyps = &yys[-1];
	yystate = 0;
	yytmp = 0;
	yynerrs = 0;
	yyerrflag = 0;
	yychar = -1;

#if YYMAXDEPTH <= 0
	if (yymaxdepth <= 0)
	{
		if ((yymaxdepth = YYEXPAND(0)) <= 0)
		{
			yyerror("yacc initialization error");
			YYABORT;
		}
	}
#endif

	{
		register YYSTYPE *yy_pv;	/* top of value stack */
		register int *yy_ps;		/* top of state stack */
		register int yy_state;		/* current state */
		register int  yy_n;		/* internal state number info */
	goto yystack;	/* moved from 6 lines above to here to please C++ */

		/*
		** get globals into registers.
		** branch to here only if YYBACKUP was called.
		*/
	yynewstate:
		yy_pv = yypv;
		yy_ps = yyps;
		yy_state = yystate;
		goto yy_newstate;

		/*
		** get globals into registers.
		** either we just started, or we just finished a reduction
		*/
	yystack:
		yy_pv = yypv;
		yy_ps = yyps;
		yy_state = yystate;

		/*
		** top of for (;;) loop while no reductions done
		*/
	yy_stack:
		/*
		** put a state and value onto the stacks
		*/
#if YYDEBUG
		/*
		** if debugging, look up token value in list of value vs.
		** name pairs.  0 and negative (-1) are special values.
		** Note: linear search is used since time is not a real
		** consideration while debugging.
		*/
		if ( yydebug )
		{
			register int yy_i;

			printf( "State %d, token ", yy_state );
			if ( yychar == 0 )
				printf( "end-of-file\n" );
			else if ( yychar < 0 )
				printf( "-none-\n" );
			else
			{
				for ( yy_i = 0; yytoks[yy_i].t_val >= 0;
					yy_i++ )
				{
					if ( yytoks[yy_i].t_val == yychar )
						break;
				}
				printf( "%s\n", yytoks[yy_i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ++yy_ps >= &yys[ yymaxdepth ] )	/* room on stack? */
		{
			/*
			** reallocate and recover.  Note that pointers
			** have to be reset, or bad things will happen
			*/
			int yyps_index = (yy_ps - yys);
			int yypv_index = (yy_pv - yyv);
			int yypvt_index = (yypvt - yyv);
			int yynewmax;
#ifdef YYEXPAND
			yynewmax = YYEXPAND(yymaxdepth);
#else
			yynewmax = 2 * yymaxdepth;	/* double table size */
			if (yymaxdepth == YYMAXDEPTH)	/* first time growth */
			{
				char *newyys = (char *)YYNEW(int);
				char *newyyv = (char *)YYNEW(YYSTYPE);
				if (newyys != 0 && newyyv != 0)
				{
					yys = YYCOPY(newyys, yys, int);
					yyv = YYCOPY(newyyv, yyv, YYSTYPE);
				}
				else
					yynewmax = 0;	/* failed */
			}
			else				/* not first time */
			{
				yys = YYENLARGE(yys, int);
				yyv = YYENLARGE(yyv, YYSTYPE);
				if (yys == 0 || yyv == 0)
					yynewmax = 0;	/* failed */
			}
#endif
			if (yynewmax <= yymaxdepth)	/* tables not expanded */
			{
				yyerror( "yacc stack overflow" );
				YYABORT;
			}
			yymaxdepth = yynewmax;

			yy_ps = yys + yyps_index;
			yy_pv = yyv + yypv_index;
			yypvt = yyv + yypvt_index;
		}
		*yy_ps = yy_state;
		*++yy_pv = yyval;

		/*
		** we have a new state - find out what to do
		*/
	yy_newstate:
		if ( ( yy_n = yypact[ yy_state ] ) <= YYFLAG )
			goto yydefault;		/* simple state */
#if YYDEBUG
		/*
		** if debugging, need to mark whether new token grabbed
		*/
		yytmp = yychar < 0;
#endif
		if ( ( yychar < 0 ) && ( ( yychar = nylex() ) < 0 ) )
			yychar = 0;		/* reached EOF */
#if YYDEBUG
		if ( yydebug && yytmp )
		{
			register int yy_i;

			printf( "Received token " );
			if ( yychar == 0 )
				printf( "end-of-file\n" );
			else if ( yychar < 0 )
				printf( "-none-\n" );
			else
			{
				for ( yy_i = 0; yytoks[yy_i].t_val >= 0;
					yy_i++ )
				{
					if ( yytoks[yy_i].t_val == yychar )
						break;
				}
				printf( "%s\n", yytoks[yy_i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ( ( yy_n += yychar ) < 0 ) || ( yy_n >= YYLAST ) )
			goto yydefault;
		if ( yychk[ yy_n = yyact[ yy_n ] ] == yychar )	/*valid shift*/
		{
			yychar = -1;
			yyval = yylval;
			yy_state = yy_n;
			if ( yyerrflag > 0 )
				yyerrflag--; nyipop();
			goto yy_stack;
		}

	yydefault:
		if ( ( yy_n = yydef[ yy_state ] ) == -2 )
		{
#if YYDEBUG
			yytmp = yychar < 0;
#endif
			if ( ( yychar < 0 ) && ( ( yychar = nylex() ) < 0 ) )
				yychar = 0;		/* reached EOF */
#if YYDEBUG
			if ( yydebug && yytmp )
			{
				register int yy_i;

				printf( "Received token " );
				if ( yychar == 0 )
					printf( "end-of-file\n" );
				else if ( yychar < 0 )
					printf( "-none-\n" );
				else
				{
					for ( yy_i = 0;
						yytoks[yy_i].t_val >= 0;
						yy_i++ )
					{
						if ( yytoks[yy_i].t_val
							== yychar )
						{
							break;
						}
					}
					printf( "%s\n", yytoks[yy_i].t_name );
				}
			}
#endif /* YYDEBUG */
			/*
			** look through exception table
			*/
			{
				register const int *yyxi = yyexca;

				while ( ( *yyxi != -1 ) ||
					( yyxi[1] != yy_state ) )
				{
					yyxi += 2;
				}
				while ( ( *(yyxi += 2) >= 0 ) &&
					( *yyxi != yychar ) )
					;
				if ( ( yy_n = yyxi[1] ) < 0 )
					YYACCEPT;
			}
		}

		/*
		** check for syntax error
		*/
		if ( yy_n == 0 )	/* have an error */
		{
			/* no worry about speed here! */
			switch ( yyerrflag )
			{
			case 0:		/* new error */
				yyerror( "syntax error" );
				goto skip_init;
			yyerrlab:
				/*
				** get globals into registers.
				** we have a user generated syntax type error
				*/
				yy_pv = yypv;
				yy_ps = yyps;
				yy_state = yystate;
			skip_init:
				yynerrs++;
				/* FALLTHRU */
			case 1:
			case 2:		/* incompletely recovered error */
					/* try again... */
				yyerrflag = 3;
				/*
				** find state where "error" is a legal
				** shift action
				*/
				while ( yy_ps >= yys )
				{
					yy_n = yypact[ *yy_ps ] + YYERRCODE;
					if ( yy_n >= 0 && yy_n < YYLAST &&
						yychk[yyact[yy_n]] == YYERRCODE)					{
						/*
						** simulate shift of "error"
						*/
						yy_state = yyact[ yy_n ];
						goto yy_stack;
					}
					/*
					** current state has no shift on
					** "error", pop stack
					*/
#if YYDEBUG
#	define _POP_ "Error recovery pops state %d, uncovers state %d\n"
					if ( yydebug )
						printf( _POP_, *yy_ps,
							yy_ps[-1] );
#	undef _POP_
#endif
					yy_ps--;
					yy_pv--;
				}
				/*
				** there is no state on stack with "error" as
				** a valid shift.  give up.
				*/
				YYABORT;
			case 3:		/* no shift yet; eat a token */
#if YYDEBUG
				/*
				** if debugging, look up token in list of
				** pairs.  0 and negative shouldn't occur,
				** but since timing doesn't matter when
				** debugging, it doesn't hurt to leave the
				** tests here.
				*/
				if ( yydebug )
				{
					register int yy_i;

					printf( "Error recovery discards " );
					if ( yychar == 0 )
						printf( "token end-of-file\n" );
					else if ( yychar < 0 )
						printf( "token -none-\n" );
					else
					{
						for ( yy_i = 0;
							yytoks[yy_i].t_val >= 0;
							yy_i++ )
						{
							if ( yytoks[yy_i].t_val
								== yychar )
							{
								break;
							}
						}
						printf( "token %s\n",
							yytoks[yy_i].t_name );
					}
				}
#endif /* YYDEBUG */
				if ( yychar == 0 )	/* reached EOF. quit */
					YYABORT;
				yychar = -1;
				goto yy_newstate;
			}
		}/* end if ( yy_n == 0 ) */
		/*
		** reduction by production yy_n
		** put stack tops, etc. so things right after switch
		*/
#if YYDEBUG
		/*
		** if debugging, print the string that is the user's
		** specification of the reduction which is just about
		** to be done.
		*/
		if ( yydebug )
			printf( "Reduce by (%d) \"%s\"\n",
				yy_n, yyreds[ yy_n ] );
#endif
		yytmp = yy_n;			/* value to switch over */
		yypvt = yy_pv;			/* $vars top of value stack */
		/*
		** Look in goto table for next state
		** Sorry about using yy_state here as temporary
		** register variable, but why not, if it works...
		** If yyr2[ yy_n ] doesn't have the low order bit
		** set, then there is no action to be done for
		** this reduction.  So, no saving & unsaving of
		** registers done.  The only difference between the
		** code just after the if and the body of the if is
		** the goto yy_stack in the body.  This way the test
		** can be made before the choice of what to do is needed.
		*/
		{
			/* length of production doubled with extra bit */
			register int yy_len = yyr2[ yy_n ];

			if ( !( yy_len & 01 ) )
			{
				yy_len >>= 1;
				yyval = ( yy_pv -= yy_len )[1];	/* $$ = $1 */
				yy_state = yypgo[ yy_n = yyr1[ yy_n ] ] +
					*( yy_ps -= yy_len ) + 1;
				if ( yy_state >= YYLAST ||
					yychk[ yy_state =
					yyact[ yy_state ] ] != -yy_n )
				{
					yy_state = yyact[ yypgo[ yy_n ] ];
				}
				goto yy_stack;
			}
			yy_len >>= 1;
			yyval = ( yy_pv -= yy_len )[1];	/* $$ = $1 */
			yy_state = yypgo[ yy_n = yyr1[ yy_n ] ] +
				*( yy_ps -= yy_len ) + 1;
			if ( yy_state >= YYLAST ||
				yychk[ yy_state = yyact[ yy_state ] ] != -yy_n )
			{
				yy_state = yyact[ yypgo[ yy_n ] ];
			}
		}
					/* save until reenter driver code */
		yystate = yy_state;
		yyps = yy_ps;
		yypv = yy_pv;
	}
	/*
	** code supplied by user is placed in this switch
	*/
	switch( yytmp )
	{
		
case 1:
# line 105 "./ny.temp.y"
{  ny__trans(1); ny__beg();  ny__orderp(1,2,1,1,0);  ny__orderp(3,2,1,1,0);   ny__orderp(1,0,0,1,0); ny__orders("\n\n");   ny__orderp(2,0,0,1,0); ny__orders("\n\n");   ny__orderp(3,0,0,1,0); ny__orders("\n");   ny__begf(); ny__orderf(0,PrintNewProductions);  ny__orders("\n\n");  ny__orderp(4,0,0,1,0);  ny__end(); 
		 ny__squish(4,0); } break;
case 2:
# line 109 "./ny.temp.y"
{  ny__trans(1); ny__beg();   ny__orderp(1,0,0,1,0); ny__orders("\n\n");   ny__orderp(2,0,0,1,0);  ny__begf(); ny__orderf(0,PrintTypeNewNonTerminals);  ny__end(); 
			 ny__trans(2); ny__beg();  ny__orderp(2,0,0,1,0);  ny__end(); 
		 ny__squish(2,0); } break;
case 3:
# line 112 "./ny.temp.y"
{  ny__trans(1); ny__beg();  ny__orders("%{");   ny__begf(); ny__orderf(0,PrintIncludes);  ny__orders("%}\n\n");   ny__orderp(1,0,0,1,0);  ny__begf(); ny__orderf(0,PrintTypeNewNonTerminals);  ny__end(); 
			 ny__trans(2); ny__beg();  ny__orderp(1,0,0,1,0);  ny__end(); 
		 ny__squish(1,0); } break;
case 4:
# line 117 "./ny.temp.y"
{  ny__trans(1); ny__beg();   ny__orderp(1,0,0,1,0);  ny__begf(); ny__orderf(0,PrintIncludes);  ny__orders("\n\n");   ny__orderp(2,0,0,1,0); ny__orders("\n");  ny__orderp(3,0,0,1,0);  ny__end(); 
		 ny__squish(3,0); } break;
case 5:
# line 121 "./ny.temp.y"
{  ny__trans(1); ny__beg();   ny__orderp(1,0,0,1,0); ny__orderp(2,0,0,1,0);  ny__end(); 
		 ny__squish(2,0); } break;
case 6:
# line 123 "./ny.temp.y"
{  ny__trans(1); ny__beg();  ny__end(); 
		 ny__squish(0,0); } break;
case 7:
# line 127 "./ny.temp.y"
{  ny__trans(1); ny__beg();   ny__begf(); ny__orderf(0,PrintTypeUntypedTokens);   ny__orderp(1,0,0,1,0); ny__orders("\n");   ny__orderp(2,0,0,1,0); ny__orders("\n");   ny__orderp(3,0,0,1,0);  ny__begf(); ny__orderf(0,PrintTypeUntypedNonTerminals);  ny__end(); 
				 ny__trans(2); ny__beg();   ny__orderp(1,0,0,1,0);  ny__orderp(2,0,0,1,0); ny__orderp(3,0,0,1,0);  ny__end(); 
			 ny__squish(3,0); } break;
case 8:
# line 132 "./ny.temp.y"
{  ny__trans(1); ny__beg();   ny__orderp(1,0,0,1,0); ny__orders(" ");   ny__orderp(2,0,0,1,0); ny__orders("\n   ");   ny__orderp(3,0,0,1,0); ny__orders(" ");   ny__orderp(4,0,0,1,0); ny__orders("\n      ");   ny__orderp(5,0,0,1,0); ny__orders(" ");   ny__orderp(6,0,0,1,0);  ny__orderp(7,0,0,1,0);  ny__begf(); ny__orderp(8,0,1,1,0); ny__orderf(1,SetNumValues);   ny__orderp(8,0,0,1,0);  ny__orderp(9,0,0,1,0);  ny__orderp(10,0,0,1,0); ny__orders("\n");   ny__orderp(11,0,0,1,0); ny__orders("\n      void * tree;\n   ");   ny__orderp(12,0,0,1,0); ny__orders(" ");   ny__orderp(13,0,0,1,0);  ny__orderp(14,0,0,1,0); ny__orders("\n");  ny__orderp(15,0,0,1,0);  ny__end(); 
			 ny__trans(2); ny__beg();   ny__begf(); ny__orderp(13,0,1,1,0); ny__orderf(1,SetStructName);  ny__end(); 
                 ny__squish(15,0); } break;
case 9:
# line 137 "./ny.temp.y"
{  ny__trans(1); ny__beg();   ny__orderp(1,0,0,1,0); ny__orderp(2,0,0,1,0);  ny__end(); 
		 ny__squish(2,0); } break;
case 10:
# line 139 "./ny.temp.y"
{  ny__trans(1); ny__beg();  ny__end(); 
		 ny__squish(0,0); } break;
case 11:
# line 143 "./ny.temp.y"
{  ny__trans(1); ny__beg();   ny__orderp(1,0,0,1,0); ny__orders("\n");  ny__orderp(2,0,0,1,0);  ny__end(); 
			 ny__trans(2); ny__beg();   ny__orderp(1,0,0,1,0); ny__orderp(2,0,0,1,0);  ny__end(); 
		 ny__squish(2,0); } break;
case 12:
# line 146 "./ny.temp.y"
{  ny__trans(1); ny__beg();  ny__end(); 
			 ny__trans(2); ny__beg();  ny__end(); 
		 ny__squish(0,0); } break;
case 13:
# line 151 "./ny.temp.y"
{  ny__trans(1); ny__beg();   ny__orderp(1,0,0,1,0); ny__orders(" ");   ny__orderp(2,0,0,1,0); ny__orders(" ");  ny__orderp(3,0,0,1,0);  ny__end(); 
			 ny__trans(2); ny__beg();   ny__begf(); ny__orderf(0,InitTokenTypedToTrue);  ny__orderp(3,0,0,1,0);  ny__end(); 
		 ny__squish(3,0); } break;
case 14:
# line 154 "./ny.temp.y"
{  ny__trans(1); ny__beg();   ny__orderp(1,0,0,1,0); ny__orders(" ");   ny__orderp(2,0,0,1,0);  ny__orderp(3,0,0,1,0);  ny__orderp(4,0,0,1,0); ny__orders(" ");  ny__orderp(5,0,0,1,0);  ny__end(); 
			 ny__trans(2); ny__beg();   ny__begf(); ny__orderf(0,InitNonTerminalTypedToTrue);  ny__orderp(5,0,0,1,0);  ny__end(); 
		 ny__squish(5,0); } break;
case 15:
# line 157 "./ny.temp.y"
{  ny__trans(1); ny__beg();   ny__orderp(1,0,0,1,0); ny__orders(" ");   ny__orderp(2,0,0,1,0);  ny__begf(); ny__orderf(0,PrintNewPseudoTokens);  ny__end(); 
			 ny__trans(2); ny__beg();   ny__begf(); ny__orderf(0,InitTokenTypedToFalse);  ny__orderp(2,0,0,1,0);  ny__end();  
		 ny__squish(2,0); } break;
case 16:
# line 160 "./ny.temp.y"
{  ny__trans(1); ny__beg();   ny__orderp(1,0,0,1,0); ny__orders(" ");   ny__orderp(2,0,0,1,0);  ny__begf(); ny__orderf(0,PrintNewPseudoTokens);  ny__end(); 
                         ny__trans(2); ny__beg();   ny__begf(); ny__orderf(0,InitTokenTypedToFalse);  ny__orderp(2,0,0,1,0);  ny__end();  
		 ny__squish(2,0); } break;
case 17:
# line 163 "./ny.temp.y"
{  ny__trans(1); ny__beg();   ny__orderp(1,0,0,1,0); ny__orders(" ");   ny__orderp(2,0,0,1,0);  ny__begf(); ny__orderf(0,PrintNewPseudoTokens);  ny__end(); 
                         ny__trans(2); ny__beg();   ny__begf(); ny__orderf(0,InitTokenTypedToFalse);  ny__orderp(2,0,0,1,0);  ny__end();  
		 ny__squish(2,0); } break;
case 18:
# line 168 "./ny.temp.y"
{  ny__trans(1); ny__beg();   ny__begf(); ny__orderf(0,PrintType);  ny__end(); 
		 ny__squish(0,0); } break;
case 19:
# line 170 "./ny.temp.y"
{  ny__trans(1); ny__beg();   ny__orderp(1,0,0,1,0);  ny__orderp(2,0,0,1,0); ny__orderp(3,0,0,1,0);  ny__end(); 
		 ny__squish(3,0); } break;
case 20:
# line 174 "./ny.temp.y"
{  ny__trans(1); ny__beg();   ny__orderp(1,0,0,1,0); ny__orders(" ");  ny__orderp(2,0,0,1,0);  ny__end(); 
                       	 ny__trans(2); ny__beg();   ny__orderp(1,0,0,1,0); ny__orderp(2,0,0,1,0);  ny__end(); 
               	 ny__squish(2,0); } break;
case 21:
# line 177 "./ny.temp.y"
{  ny__trans(1); ny__beg();  ny__orderp(1,0,0,1,0);  ny__end(); 
                       	 ny__trans(2); ny__beg();  ny__orderp(1,0,0,1,0);  ny__end(); 
               	 ny__squish(1,0); } break;
case 22:
# line 182 "./ny.temp.y"
{  ny__trans(1); ny__beg();  ny__orderp(1,0,0,1,0);  ny__end(); 
                       	 ny__trans(2); ny__beg();   ny__begf(); ny__orderp(1,0,1,1,0); ny__orderf(1,AddTokenSymbol);  ny__end(); 
               	 ny__squish(1,0); } break;
case 23:
# line 185 "./ny.temp.y"
{  ny__trans(1); ny__beg();  ny__orderp(1,0,0,1,0);  ny__end(); 
                       	 ny__trans(2); ny__beg();   ny__begf(); ny__orderp(1,0,1,1,0); ny__orderf(1,AddTokenSymbol);  ny__end(); 
               	 ny__squish(1,0); } break;
case 24:
# line 190 "./ny.temp.y"
{  ny__trans(1); ny__beg();   ny__orderp(1,0,0,1,0); ny__orders(" ");  ny__orderp(2,0,0,1,0);  ny__end(); 
			 ny__trans(2); ny__beg();   ny__orderp(1,0,0,1,0);  ny__begf(); ny__orderp(2,0,1,1,0); ny__orderf(1,AddNonTerminalSymbol);  ny__end(); 
		 ny__squish(2,0); } break;
case 25:
# line 193 "./ny.temp.y"
{  ny__trans(1); ny__beg();  ny__orderp(1,0,0,1,0);  ny__end(); 
			 ny__trans(2); ny__beg();   ny__begf(); ny__orderp(1,0,1,1,0); ny__orderf(1,AddNonTerminalSymbol);  ny__end(); 
		 ny__squish(1,0); } break;
case 26:
# line 198 "./ny.temp.y"
{  ny__trans(1); ny__beg();   ny__orderp(1,0,0,1,0); ny__orders(" ");  ny__orderp(2,0,0,1,0);  ny__end(); 
                         ny__trans(2); ny__beg();   ny__orderp(1,0,0,1,0); ny__orderp(2,0,0,1,0);  ny__end(); 
                 ny__squish(2,0); } break;
case 27:
# line 201 "./ny.temp.y"
{  ny__trans(1); ny__beg();  ny__orderp(1,0,0,1,0);  ny__end(); 
                         ny__trans(2); ny__beg();  ny__orderp(1,0,0,1,0);  ny__end(); 
                 ny__squish(1,0); } break;
case 28:
# line 206 "./ny.temp.y"
{  ny__trans(1); ny__beg();   ny__orderp(1,0,0,1,0);  ny__begf(); ny__orderp(1,0,1,1,0); ny__orderf(1,MarkWithThisPrec);  ny__end(); 
                         ny__trans(2); ny__beg();   ny__begf(); ny__orderp(1,0,1,1,0); ny__orderf(1,AddTokenSymbol);   ny__begf(); ny__orderp(1,0,1,1,0); ny__orderf(1,MarkWithPrec);  ny__end(); 
                 ny__squish(1,0); } break;
case 29:
# line 209 "./ny.temp.y"
{  ny__trans(1); ny__beg();   ny__orderp(1,0,0,1,0);  ny__begf(); ny__orderp(1,0,1,1,0); ny__orderf(1,MarkWithThisPrec);  ny__end(); 
                         ny__trans(2); ny__beg();   ny__begf(); ny__orderp(1,0,1,1,0); ny__orderf(1,AddTokenSymbol);   ny__begf(); ny__orderp(1,0,1,1,0); ny__orderf(1,MarkWithPrec);  ny__end(); 
                 ny__squish(1,0); } break;
case 30:
# line 214 "./ny.temp.y"
{  ny__trans(1); ny__beg();   ny__orderp(1,0,0,1,0); ny__orders("\n\n");  ny__orderp(2,0,0,1,0);  ny__end(); 
			 ny__trans(2); ny__beg();   ny__orderp(1,0,0,1,0); ny__orderp(2,0,0,1,0);  ny__end(); 
		 ny__squish(2,0); } break;
case 31:
# line 217 "./ny.temp.y"
{  ny__trans(1); ny__beg();  ny__orderp(1,0,0,1,0);  ny__end(); 
			 ny__trans(2); ny__beg();  ny__orderp(1,0,0,1,0);  ny__end(); 
		 ny__squish(1,0); } break;
case 32:
# line 222 "./ny.temp.y"
{  ny__trans(1); ny__beg();   ny__begf(); ny__orderp(1,0,1,1,0); ny__orderf(1,InitNonTerminalName);   ny__orderp(1,0,0,1,0); ny__orders("\t");   ny__orderp(2,0,0,1,0); ny__orders("\t");   ny__orderp(3,0,0,1,0); ny__orders("\n\t\t");  ny__orderp(4,0,0,1,0);  ny__end(); 
			 ny__trans(2); ny__beg();   ny__begf(); ny__orderf(0,InitNonTerminalTypedToFalse);   ny__begf(); ny__orderp(1,0,1,1,0); ny__orderf(1,AddNonTerminalSymbol);   ny__begf(); ny__orderf(0,InitTokenTypedToFalse);  ny__orderp(3,0,0,1,0);  ny__end(); 
		 ny__squish(4,0); } break;
case 33:
# line 227 "./ny.temp.y"
{  ny__trans(1); ny__beg();   ny__orderp(1,0,0,1,0); ny__orders("\n\t\t");   ny__orderp(2,0,0,1,0); ny__orders("\t");   ny__begf(); ny__orderf(0,InitRHSElementsCount);  ny__orderp(3,0,0,1,0);  ny__end(); 
			 ny__trans(2); ny__beg();   ny__orderp(1,0,0,1,0); ny__orderp(3,0,0,1,0);  ny__end(); 
		 ny__squish(3,0); } break;
case 34:
# line 230 "./ny.temp.y"
{  ny__trans(1); ny__beg();   ny__begf(); ny__orderf(0,InitRHSElementsCount);  ny__orderp(1,0,0,1,0);  ny__end(); 
			 ny__trans(2); ny__beg();  ny__orderp(1,0,0,1,0);  ny__end(); 
		 ny__squish(1,0); } break;
case 35:
# line 235 "./ny.temp.y"
{  ny__trans(1); ny__beg();   ny__orderp(1,0,0,1,0); ny__orders(" ");   ny__orderp(2,0,0,1,0); ny__orders("\n\t\t\t");  ny__orderp(3,0,0,1,0);  ny__end(); 
			 ny__trans(2); ny__beg();  ny__orderp(1,0,0,1,0);  ny__end(); 
		 ny__squish(3,0); } break;
case 36:
# line 238 "./ny.temp.y"
{  ny__trans(1); ny__beg();   ny__begf(); ny__orderf(0,InitCurPrec);   ny__orderp(1,0,0,1,0);  ny__begf(); ny__orderf(0,PrintNonPrecedence);  ny__orders("\n\t\t\t");  ny__orderp(2,0,0,1,0);  ny__end(); 
			 ny__trans(2); ny__beg();  ny__orderp(1,0,0,1,0);  ny__end(); 
                 ny__squish(2,0); } break;
case 37:
# line 241 "./ny.temp.y"
{  ny__trans(1); ny__beg();   ny__orderp(1,0,0,1,0); ny__orders(" ");   ny__orderp(2,0,0,1,0); ny__orders("\n\t\t\t");   ny__begf(); ny__orderf(0,PrintNonAction);  ny__end(); 
			 ny__trans(2); ny__beg();  ny__orderp(1,0,0,1,0);  ny__end(); 
                 ny__squish(2,0); } break;
case 38:
# line 244 "./ny.temp.y"
{  ny__trans(1); ny__beg();   ny__begf(); ny__orderf(0,InitCurPrec);   ny__orderp(1,0,0,1,0);  ny__begf(); ny__orderf(0,PrintNonPrecedence);  ny__orders("\n\t\t\t");   ny__begf(); ny__orderf(0,PrintNonAction);  ny__end(); 
                         ny__trans(2); ny__beg();  ny__orderp(1,0,0,1,0);  ny__end(); 
		 ny__squish(1,0); } break;
case 39:
# line 249 "./ny.temp.y"
{  ny__trans(1); ny__beg();   ny__orderp(1,0,0,1,0); ny__orders(" ");   ny__orderp(2,0,0,1,0);  ny__begf(); ny__orderf(0,IncrRHSElementsCount);  ny__end(); 
			 ny__trans(2); ny__beg();   ny__orderp(1,0,0,1,0); ny__orderp(2,0,0,1,0);  ny__end(); 
		 ny__squish(2,0); } break;
case 40:
# line 252 "./ny.temp.y"
{  ny__trans(1); ny__beg();  ny__end(); 
			 ny__trans(2); ny__beg();  ny__end(); 
		 ny__squish(0,0); } break;
case 41:
# line 257 "./ny.temp.y"
{  ny__trans(1); ny__beg();   ny__begf(); ny__orderp(1,0,1,1,0); ny__orderf(1,LookupTokenSymbol);  ny__end(); 
			 ny__trans(2); ny__beg();  ny__end(); 
		 ny__squish(1,0); } break;
case 42:
# line 260 "./ny.temp.y"
{  ny__trans(1); ny__beg();   ny__begf(); ny__orderp(1,0,1,1,0); ny__orderf(1,LookupTokenSymbol);  ny__end(); 
			 ny__trans(2); ny__beg();   ny__begf(); ny__orderp(1,0,1,1,0); ny__orderf(1,AddTokenSymbol);  ny__end(); 
		 ny__squish(1,0); } break;
case 43:
# line 265 "./ny.temp.y"
{  ny__trans(1); ny__beg();   ny__orderp(1,0,0,1,0); ny__orders(" ");  ny__orderp(2,0,0,1,0);  ny__end(); 
		 ny__squish(2,0); } break;
case 44:
# line 269 "./ny.temp.y"
{  ny__trans(1); ny__beg();   ny__orderp(1,0,0,1,0);  ny__begf(); ny__orderf(0,InitCurlyCount);  ny__orders("\n\t\t\t");   ny__orderp(2,0,0,1,0); ny__orders("\n\t\t\t");   ny__begf(); ny__orderf(0,PrintEndAction);  ny__orders("\n\t\t\t");  ny__orderp(3,0,0,1,0);  ny__end(); 
		 ny__squish(3,0); } break;
case 45:
# line 273 "./ny.temp.y"
{  ny__trans(1); ny__beg();   ny__orderp(1,0,0,1,0); ny__orderp(2,0,0,1,0);  ny__end(); 
		 ny__squish(2,0); } break;
case 46:
# line 275 "./ny.temp.y"
{  ny__trans(1); ny__beg();   ny__orderp(1,0,0,1,0); ny__orders("\n\t\t\t");   ny__begf(); ny__orderf(0,PrintCurlyIndent);  ny__end(); 
		 ny__squish(2,0); } break;
case 47:
# line 277 "./ny.temp.y"
{  ny__trans(1); ny__beg();   ny__orderp(1,0,0,1,0); ny__orders(" ");  ny__end(); 
		 ny__squish(2,0); } break;
case 48:
# line 279 "./ny.temp.y"
{  ny__trans(1); ny__beg();   ny__orderp(1,0,0,1,0);  ny__begf(); ny__orderf(0,IncrCurlyCount);  ny__orders("{");  ny__end(); 
		 ny__squish(2,0); } break;
case 49:
# line 281 "./ny.temp.y"
{  ny__trans(1); ny__beg();   ny__orderp(1,0,0,1,0);  ny__begf(); ny__orderf(0,DecrCurlyCount);  ny__orders("}");  ny__end(); 
		 ny__squish(2,0); } break;
case 50:
# line 283 "./ny.temp.y"
{  ny__trans(1); ny__beg();   ny__orderp(1,0,0,1,0); ny__orderp(2,0,0,1,0);  ny__end(); 
		 ny__squish(2,0); } break;
case 51:
# line 285 "./ny.temp.y"
{  ny__trans(1); ny__beg();   ny__orderp(1,0,0,1,0); ny__orderp(2,0,0,1,0);  ny__end(); 
		 ny__squish(2,0); } break;
case 52:
# line 287 "./ny.temp.y"
{  ny__trans(1); ny__beg();  ny__end(); 
		 ny__squish(0,0); } break;
case 53:
# line 291 "./ny.temp.y"
{  ny__trans(1); ny__beg();   ny__orderp(1,0,0,1,0);  ny__orderp(2,0,0,1,0); ny__orderp(3,0,0,1,0);  ny__end(); 
		 ny__squish(3,0); } break;
case 54:
# line 295 "./ny.temp.y"
{  ny__trans(1); ny__beg();   ny__orderp(1,0,0,1,0); ny__orderp(2,0,0,1,0);  ny__end(); 
		 ny__squish(2,0); } break;
case 55:
# line 297 "./ny.temp.y"
{  ny__trans(1); ny__beg();   ny__orderp(1,0,0,1,0); ny__orderp(2,0,0,1,0);  ny__end(); 
		 ny__squish(2,0); } break;
case 56:
# line 299 "./ny.temp.y"
{  ny__trans(1); ny__beg();  ny__end(); 
		 ny__squish(0,0); } break;
case 57:
# line 303 "./ny.temp.y"
{  ny__trans(1); ny__beg();   ny__orderp(1,0,0,1,0);  ny__orderp(2,0,0,1,0); ny__orderp(3,0,0,1,0);  ny__end(); 
		 ny__squish(3,0); } break;
case 58:
# line 307 "./ny.temp.y"
{  ny__trans(1); ny__beg();   ny__orderp(1,0,0,1,0); ny__orderp(2,0,0,1,0);  ny__end(); 
		 ny__squish(2,0); } break;
case 59:
# line 309 "./ny.temp.y"
{  ny__trans(1); ny__beg();   ny__orderp(1,0,0,1,0); ny__orderp(2,0,0,1,0);  ny__end(); 
		 ny__squish(2,0); } break;
case 60:
# line 311 "./ny.temp.y"
{  ny__trans(1); ny__beg();  ny__end(); 
		 ny__squish(0,0); } break;
case 61:
# line 315 "./ny.temp.y"
{  ny__trans(1); ny__beg();   ny__begf(); ny__orderf(0,PrintSecondDivider);  ny__end(); 
                 ny__squish(0,0); } break;
case 62:
# line 317 "./ny.temp.y"
{  ny__trans(1); ny__beg();   ny__begf(); ny__orderf(0,PrintSecondDivider);  ny__orderp(2,0,0,1,0);  ny__end(); 
                 ny__squish(2,0); } break;
case 63:
# line 321 "./ny.temp.y"
{  ny__trans(1); ny__beg();   ny__orderp(1,0,0,1,0); ny__orderp(2,0,0,1,0);  ny__end(); 
                 ny__squish(2,0); } break;
case 64:
# line 323 "./ny.temp.y"
{  ny__trans(1); ny__beg();  ny__end(); 
                 ny__squish(0,0); } break;
# line	531 "/usr/ccs/bin/yaccpar"
	}
	goto yystack;		/* reset registers in driver code */
}

