from collections import Counter
import sys
import csv

from scipy import stats
import matplotlib
matplotlib.use('Agg') # Must be before importing matplotlib.pyplot or pylab!
import matplotlib.pyplot as plt

import pandas as pd
import numpy as np


a = []
def parse_file(sim_file, get_overall):
    global a
    with open(sim_file) as topo_file:
        for l in topo_file:
            if l.startswith("Test:"):
                # print '================================================================'
                test = l.split(' ')[1]
            elif l.startswith("Info:"):
                test = l.split(')')[0].split('(')[1]
            elif l.startswith("Cat:"):
                cat = l.split(' ')[1]
            elif l.startswith('Order:'):
                order = l.split(' ')[1].strip()
            elif l.startswith('fails:') or l.startswith('failc:') or l.startswith('oneOrMoreFails:'):
                if order.endswith("_reverse") and not get_overall:
                    fails = l.split(' ')[7]
                    runs = l.split(' ')[9]
                else:
                    fails = l.split(' ')[1]
                    runs = l.split(' ')[3]
                is_simulated = len(l.split(' ')) >= 11 and  l.split(' ')[10].strip() == "simulated===="
                a = a + [[test, cat, order, fails, runs, is_simulated]]
    return a

def parse_tests_to_ignore(dep_file):
    d = set()
    with open(dep_file) as f:
        for r in csv.reader(f):
            if len(r) == 0:
                continue
            d.add(r[3])
    return d


# if __name__ == '__main__':
inputs = sys.argv
sim_file = inputs[1]
get_overall = {"true":True,"false":False}[inputs[3].lower()]
ignore_simulated = {"true":True,"false":False}[inputs[4].lower()]
tests_to_ignore = parse_tests_to_ignore(inputs[5])
a = parse_file(sim_file, get_overall)

configs = inputs[2].split(';')
config_one = configs[0]
config_two = configs[1]

R = 50000
classes = []
d = {}
p = {}
from math import sqrt
paired = {}
def inner(mixed_strategy_name, strategy1, strategy2):
    paired[mixed_strategy_name] = paired.get(mixed_strategy_name, []) + [100 * (1 - (1 - float(d[strategy1][-1]) / 100) * (1 - float(d[strategy2][-1]) / 100))]

png_name='ss-real.png'

#CORP = 'continue'
CORP = 'pass'
mapp = { 'new_old_tests_default randomize_junit': 'fC(T)', 'new_old_tests_default randomize_junit_reverse': 'fC_r(T)', 'new_old_tests_default randomize': 'fA(T)', 'new_old_tests_default randomize_reverse': 'fA_r(T)' }
for t in (set(r[0] for r in a) -  tests_to_ignore):
    if t.split('.')[:-1] in classes:
        if CORP == 'continue':
            continue
    classes.append(t.split('.')[:-1])
    for r in filter(lambda x: x[0] == t, a):
        oco = r[1] + " " + r[2]
        if oco not in mapp.keys():
            continue
        co = mapp[oco]
        # if not co == 'ir' and not co == 'jr':
        #     continue
        if co == 'MGr' or co == 'MGr':
            continue
        if ignore_simulated and r[5]:
            continue
        d[co] = d.get(co, []) + [int(r[3]) / (int(r[4]) / 100.0)]
        # print str.format("{},{}", r[0], r[5])

for p in [str.format("{}{}M", config_one, config_two)]:
    index = ['fC(T)', 'fA(T)']
    df = pd.DataFrame(dict(filter(lambda i : i[0][0] in p, d.items())))
    # for co in ['zbb', 'zbe', 'zb', 'z', 'ybb', 'ybe', 'yb', 'y']:
    #     print co + " " + str(df[co].mean()) + " " + str(df[co].std()) + " " + str(df[co].mean() / df[co].std())
    # plot = df.plot.box(grid='True', showmeans = True, medianprops={'linestyle': None, 'linewidth': 0})
    # default figsize 6.4, 4.8
    print str.format("describe: {}", df[[config_one,config_two]].describe())
    print str.format("ttest: {}", stats.ttest_rel(df[config_one], df[config_two]))
    print str.format("wilcoxon: {}", stats.wilcoxon(df[config_one], df[config_two]))
    (plot, plotdict) = df.boxplot(figsize=(6.4, 1.5),vert=False,grid='True', showmeans = True, widths=0.6, medianprops={'linestyle': None, 'linewidth': 0}, return_type='both', column=index)
    locs, labels = plt.xticks()
    # for element in ['medians']:
    #     plt.setp(plotdict[element], color='r')
    plt.xticks(locs, ['', '0%', '20%', '40%', '60%', '80%', '100%', ''])
    plt.xlim(-2, 101)
    plot.set_aspect(10.5)
    fig = plot.get_figure()
    fig.savefig(p + '-' + png_name)

