#!/bin/bash

repo=$(git rev-parse HEAD)
echo "script vers: $repo"
starttime=$(date)
echo "starttime: $starttime"

echo "Generating test-deps.csv"
cut -d, -f4,5,6,7 all-polluter-cleaner-info-combined.csv > test-deps.csv

echo "Generating omega-c-reverse.out"
for f in $(cut -d, -f4 all-polluter-cleaner-info-combined.csv | sort -u); do python get_od_fail_info.py test-deps.csv $f 100000 'omega_c;omega_c_reverse_passing' false; done > omega-c-reverse.out

echo "Generating omega-a-reverse.out"
for f in $(cut -d, -f4 all-polluter-cleaner-info-combined.csv | sort -u); do python get_od_fail_info.py test-deps.csv $f 100000 'omega_a;omega_a_reverse_passing' false; done > omega-a-reverse.out

echo "Generating omega-a-omega-c-comp.out"
for f in $(cut -d, -f4 all-polluter-cleaner-info-combined.csv | sort -u); do python get_od_fail_info.py test-deps.csv $f 100000 'omega_a;omega_c' false; done > omega-a-omega-c-comp.out

echo "Generating omega-a-omega-c-comp-formulas.out"
for f in $(cut -d, -f4 all-polluter-cleaner-info-combined.csv | sort -u); do python get_od_fail_info.py test-deps.csv $f 100000 'omega_a;omega_c' true; done > omega-a-omega-c-comp-formulas.out

endtime=$(date)
echo "endtime: $endtime"
