#!/bin/bash

repo=$(git rev-parse HEAD)
echo "script vers: $repo"
starttime=$(date)
echo "starttime: $starttime"

echo "================ Generating omega-c get reverse only stats"
python gen-sim-plots.py omega-c-reverse.out 'fC(T);fC_r(T)' false false tuscan-40-r2.csv;

echo "================ Generating omega-a get reverse only stats"
python gen-sim-plots.py omega-a-reverse.out 'fA(T);fA_r(T)' false false tuscan-40-r2.csv;

echo "================ Generating omega-c get overall stats"
python gen-sim-plots.py omega-c-reverse.out 'fC(T);fC_r(T)' true false tuscan-40-r2.csv;

echo "================ Generating omega-a get overall stats"
python gen-sim-plots.py omega-a-reverse.out 'fA(T);fA_r(T)' true false tuscan-40-r2.csv;

echo "================ Generating omega-a and omega-c get all formula and simulated stats"
python gen-sim-plots.py omega-a-omega-c-comp-formulas.out 'fA(T);fC(T)' true false tuscan-40-r2.csv;

echo "================ Generating omega-a and omega-c get all formula (ignore simulated) stats"
python gen-sim-plots.py omega-a-omega-c-comp-formulas.out 'fA(T);fC(T)' true true tuscan-40-r2.csv;

echo "================ Generating omega-a and omega-c get all simulated stats"
python gen-sim-plots.py omega-a-omega-c-comp.out 'fA(T);fC(T)' true false tuscan-40-r2.csv;

endtime=$(date)
echo "endtime: $endtime"
