There are two main scripts in this directory.
- ```gen-sims.sh``` generates all the simulation/formula results for the 289 tests of the paper. Takes about 2 hours to run. To save time, the simulation results used for the paper is saved as ```omega-c-reverse.out```, ```omega-a-reverse.out```, ```omega-a-omega-c-comp.out```, and ```omega-a-omega-c-comp-formulas.out```. 
- ```gen-stats.sh``` generates all the statistics for the 249 confirmed tests of the paper using the simulation/formula results. Takes about 20 seconds to run. An example of what running the script will output is saved as ```gen-stats.out````. To get the statistics for all 289 tests, simply replace the ```tuscan-40-r2.csv``` file with an empty file. An example of the output for all 289 tests is in ```gen-stats-all-tests.out```.

Other contents of the directory include:
- ```all-polluter-cleaner-info-combined.csv``` file containing all dependency information and slug,sha,module information for all 289 tests
- ```all-polluter-cleaner-info-combined-filtered-fp.csv``` file containing all dependency information and slug,sha,module information for all 249 tests (289 - 40 new tests we could not confirm with Maven Surefire) 
- ```gen-sim-plots.py``` python script to generate plots and statistics for the paper
- ```get_od_fail_info.py``` python script to generate simulation/formula results
- ```test-deps.csv``` file containing just dependency information obtained from ```all-polluter-cleaner-info-combined.csv```
- ```tests-used-simulation.csv``` file containing for 289 tests whether the test can use formula or not. False means that the test can use formulas
- ```tuscan-40-r2.csv``` file containing 40 tests that were unable to be confirmed by running their passing/failing orders in Maven Surefire
